% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoxExport.R
\name{WriteICESDatras}
\alias{WriteICESDatras}
\title{Write ICES DATRAS (NS-IBTS) format file}
\usage{
WriteICESDatras(BioticData, AddStationType = NA_character_, Combine = FALSE)
}
\arguments{
\item{BioticData}{a \code{BioticData} object from an XML file with NMD biotic version 3 format.}

\item{AddStationType}{additional StationType to be included. By default only fish stations with StationType == NA are included.}

\item{Combine}{Logical: If TRUE stack the output tables for each acosutic file.}
}
\value{
List of data.table objects in the ICES DATRAS CSV format.
}
\description{
Given an \code{BioticData} object, this function will write an ICES DATRAS (NS-IBTS) file. Note that this function only supports
\code{BioticData} object that is created from reading an NMD biotic version 3 XML file.
}
