% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read.R
\name{ReadLanding}
\alias{ReadLanding}
\title{Read landing XML files}
\usage{
ReadLanding(FileNames)
}
\arguments{
\item{FileNames}{The paths of the landing files.}
}
\value{
An object of StoX data type \code{\link[RstoxData]{LandingData}}).
}
\description{
This function reads multiple landing files (sales-notes) to a list with a list of tables for each file.
}
\details{
This sales notes are expected to be XML-formatted with elements defined by the namespace: http://www.imr.no/formats/landinger/v2
}
\examples{
exampleFile <- system.file(
    "testresources","landing.xml", package="RstoxData")
landingData <- ReadLanding(exampleFile)

}
\seealso{
\code{\link[RstoxData]{readXmlFile}}.
}
