% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_experiment.R
\name{check_experiment}
\alias{check_experiment}
\title{Check experiment data.}
\usage{
check_experiment(
  filename,
  format = NA,
  interpolate = FALSE,
  project.dir = NA,
  data.dir = project.dir,
  cluster = NULL,
  author.note = "",
  verbose = FALSE
)
}
\arguments{
\item{filename}{A spreadsheet file containing a description of the experiment
or a JSON file containing an exported experiment archive.}

\item{format}{An experiment description for reading raw data can be provided
as an Excel spreadsheet ('excel'; the default) or as a comma-delimited
('csv') or tab-delimited ("tab", "tsv", "txt" or "text") text file. The
value 'json' indicates that the file is an archived experiment in the JSON
format (as generated by \code{\link{export_json}}). Default (\code{NA}) is
to guess the format from the file extension.}

\item{interpolate}{Ignored. For compatibility with
\code{\link{read_experiment}}.}

\item{project.dir}{A directory path specifying where the files needed for
processing the experiment are stored. Ignored if \code{format = "json"}.}

\item{data.dir}{A directory path specifying where the raw data are stored.
This is a folder root and all paths specified in the spreadsheet. Ignored
if \code{format = "json"}.}

\item{cluster}{Ignored. For compatibility with \code{\link{read_experiment}}.}

\item{author.note}{Ignored. For compatibility with
\code{\link{read_experiment}}.}

\item{verbose}{Ignored. For compatibility with \code{\link{read_experiment}}.}
}
\value{
Invisibly returns \code{TRUE} for a successful check or \code{FALSE}
  otherwise.
}
\description{
Checks that the experiment description is well-formed and complete.
}
\details{
Information about a full experiment can be assembled into a spreadsheet
(currently Excel, CSV and tab-delimited text formats are supported) and used
to process large numbers of files in one batch. This function checks the
spreadsheet to make sure that it is properly formed and that all the data
files referred to are present.

The function can (and ideally should) be run with the same parameters as will
be used to call \code{\link{read_experiment}}, although many of the
parameters are not required for the check.

The content of the spreadsheet, the presence and the content of any
supporting files are also checked. Checks do not cover validity of the raw
data, so it is still possible to have invalid data even if
\code{\link{check_experiment}} returns \code{TRUE} (although this suggests an
underlying problem with the raw data). Warning and error messages are
intended to be useful and help any format issues be quickly resolved.
}
\examples{
require(Rtrack)
experiment.description <- system.file("extdata", "Minimal_experiment.xlsx",
  package = "Rtrack")
check_experiment(experiment.description)
}
\seealso{
\code{\link{read_experiment}}, \code{\link{export_json}}.
}
