% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaRunningMeanTrend}
\alias{tsEvaRunningMeanTrend}
\title{Calculate the running mean trend of a time series}
\usage{
tsEvaRunningMeanTrend(timeStamps, series, timeWindow)
}
\arguments{
\item{timeStamps}{A vector of time stamps corresponding to the observations in the series.}

\item{series}{A vector of numeric values representing the time series.}

\item{timeWindow}{The length of the time window (in the same time units as the time stamps) used for calculating the running mean trend.}
}
\value{
A list containing the running mean trend series and the number of observations used for each running mean calculation.
}
\description{
This function calculates the running mean trend of a given time series using a specified time window.
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series  <- ArdecheStMartin[,2]
timeWindow <- 365*30
result <- tsEvaRunningMeanTrend(timeStamps, series, timeWindow)
result$trendSeries
result$nRunMn

}
