% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.shuffle.R
\name{MVQuantilesShuffle}
\alias{MVQuantilesShuffle}
\title{MVQuantilesShuffle}
\description{
Multivariate Schaake shuffle using the quantiles.
}
\details{
Used to reproduce the dependence structure of a dataset to another dataset
}
\examples{
## Generate sample
X = matrix( stats::rnorm( n = 100 ) , ncol = 4 )
Y = matrix( stats::rnorm( n = 100 ) , ncol = 4 )

## Fit dependence structure
## Assume that the link beween column 2 and 4 is correct, and change also
## the auto-correlation structure until lag 3 = lag_keep - 1
mvq = MVQuantilesShuffle$new( base::c(2,4) , lag_search = 6 , lag_keep = 4 )
mvq$fit(Y)
Z = mvq$transform(X)

}
\references{
Vrac, M. et S. Thao (2020). “R2 D2 v2.0 : accounting for temporal
            dependences in multivariate bias correction via analogue rank
            resampling”. In : Geosci. Model Dev. 13.11, p. 5367-5387.
            doi :10.5194/gmd-13-5367-2020.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{col_cond}}{[vector] Conditionning columns}

\item{\code{col_ucond}}{[vector] Un-conditionning columns}

\item{\code{lag_search}}{[integer] Number of lags to transform the dependence structure}

\item{\code{lag_keep}}{[integer] Number of lags to keep}

\item{\code{n_features}}{[integer] Number of features (dimensions), internal}

\item{\code{qY}}{[matrix] Quantile structure fitted, internal}

\item{\code{bsYc}}{[matrix] Block search fitted, internal}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MVQuantilesShuffle-new}{\code{MVQuantilesShuffle$new()}}
\item \href{#method-MVQuantilesShuffle-fit}{\code{MVQuantilesShuffle$fit()}}
\item \href{#method-MVQuantilesShuffle-transform}{\code{MVQuantilesShuffle$transform()}}
\item \href{#method-MVQuantilesShuffle-clone}{\code{MVQuantilesShuffle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MVQuantilesShuffle-new"></a>}}
\if{latex}{\out{\hypertarget{method-MVQuantilesShuffle-new}{}}}
\subsection{Method \code{new()}}{
Create a new MVQuantilesShuffle object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MVQuantilesShuffle$new(col_cond = base::c(1), lag_search = 1, lag_keep = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col_cond}}{Conditionning colum}

\item{\code{lag_search}}{Number of lags to transform the dependence structure}

\item{\code{lag_keep}}{Number of lags to keep}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `MVQuantilesShuffle` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MVQuantilesShuffle-fit"></a>}}
\if{latex}{\out{\hypertarget{method-MVQuantilesShuffle-fit}{}}}
\subsection{Method \code{fit()}}{
Fit method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MVQuantilesShuffle$fit(Y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{[vector] Dataset to infer the dependance structure}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MVQuantilesShuffle-transform"></a>}}
\if{latex}{\out{\hypertarget{method-MVQuantilesShuffle-transform}{}}}
\subsection{Method \code{transform()}}{
Transform method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MVQuantilesShuffle$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{[vector] Dataset to match the dependance structure with the Y fitted}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Z The X with the quantiles structure of Y
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MVQuantilesShuffle-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MVQuantilesShuffle-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MVQuantilesShuffle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
