% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmod.R
\name{dma}
\alias{dma}
\title{Dirichlet Multinomial Allocation}
\usage{
dma(gamma, delta)
}
\arguments{
\item{gamma}{parameter for Dirichlet component}

\item{delta}{parameter for Poison component}
}
\value{
a block model representing a \code{dma(gamma, delta)} distribution
}
\description{
A \code{\link{blockmod}} for Dirichlet Multinomial Allocation (DMA)
}
\details{
This model posits:
\deqn{kappa-1 ~ Pois(delta)}
\deqn{omega|kappa, gamma ~ Dirichlet(gamma)}
\deqn{Z_i|omega ~ Multinomial(omega) for i=1 .. n}
}
\examples{
## simulate from a DMA(2, 5) prior
## This models the `number of blocks-1` as Poisson(5)
## and block assignments as Dirichlet-Multinomial(2, 2, ...)
m <- dma(2, 5)
print(m)
m$r(10)
}
