% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_prediction.R
\name{simulation_prediction_conti}
\alias{simulation_prediction_conti}
\title{Simulate Continuous Longitudinal Data for Prediction}
\usage{
simulation_prediction_conti(
  train_prop = 0.7,
  n_subject = 1000,
  n_obs_per_sub = 5,
  seed = NULL,
  nonlinear = FALSE,
  residual = c("normal", "normal_mixture", "skewed_normal", "t3", "t2"),
  randeff = c("MVN", "MVN_mixture", "skewed_MVN", "MVT3", "MVT2")
)
}
\arguments{
\item{train_prop}{A numeric value between 0 and 1 indicating the proportion of the population to be used
for the training set. Default: \code{0.7}.}

\item{n_subject}{An integer specifying the total number of subjects in the population. Default: \code{1000}.}

\item{n_obs_per_sub}{An integer specifying the number of observations per subject. Default: \code{5}.}

\item{seed}{An optional integer for setting the random seed to ensure reproducibility. Default: \code{NULL}.}

\item{nonlinear}{A logical value. If \code{TRUE}, the outcome \code{Y} is generated using a complex
nonlinear function of the covariates. If \code{FALSE}, \code{Y} is a linear combination of covariates.
Default: \code{FALSE}.}

\item{residual}{A character string specifying the distribution of the residual errors added to the training outcome.
Options are:
\itemize{
\item \code{"normal"}: Standard normal distribution.
\item \code{"normal_mixture"}: Mixture of two normal distributions.
\item \code{"skewed_normal"}: Skew-normal distribution.
\item \code{"t3"}: Student's t-distribution with 3 degrees of freedom.
\item \code{"t2"}: Student's t-distribution with 2 degrees of freedom.
}}

\item{randeff}{A character string specifying the distribution of the random effects.
Options are:
\itemize{
\item \code{"MVN"}: Multivariate Normal distribution.
\item \code{"MVN_mixture"}: Mixture of Multivariate Normal distributions.
\item \code{"skewed_MVN"}: Multivariate Skew-normal distribution.
\item \code{"MVT3"}: Multivariate t-distribution with 3 degrees of freedom.
\item \code{"MVT2"}: Multivariate t-distribution with 2 degrees of freedom.
}}
}
\value{
A list containing the following components:
\describe{
\item{subject_id_train}{A vector of subject IDs for the training set.}
\item{Z_train}{A matrix of random predictors (time/intercept) for the training set.}
\item{X_train}{A matrix of covariates for the training set.}
\item{Y_train}{A vector of observed outcomes for the training set (Signal + Random Effects + Residual Error).}
\item{subject_id_test}{A vector of subject IDs for the testing set.}
\item{Z_test}{A matrix of random predictors for the testing set.}
\item{X_test}{A matrix of covariates for the testing set.}
\item{Y_test}{A vector of "true" outcomes for the testing set (Signal + Random Effects), without residual error.}
\item{X_pop}{A matrix of covariates for the entire population.}
\item{y_pop}{A vector of "true" outcomes for the entire population (Signal + Random Effects).}
\item{I}{A logical vector indicating which observations belong to the training set.}
\item{X_src}{Duplicate of \code{X_train}, provided for convenience.}
\item{Y_src}{Duplicate of \code{Y_train}, provided for convenience.}
}
}
\description{
Generates synthetic longitudinal data with continuous outcomes, specifically designed for
evaluating prediction models. The function creates a population of subjects with correlated covariates
and outcomes, then splits them into training and testing sets. It offers flexible options for
simulating non-normal random effects (e.g., skewed, mixtures, t-distributions) and residuals,
as well as nonlinear relationships.
}
\details{
The function first simulates correlated covariates \code{X} using a multivariate normal distribution,
adding subject-specific random variations. The outcome \code{Y} is then constructed based on \code{X}
(either linearly or nonlinearly) and combined with random effects \code{Z * Bi} drawn from the
specified \code{randeff} distribution.

The data is split into training and testing sets based on \code{train_prop}. Crucially, residual noise
(specified by \code{residual}) is added \strong{only} to \code{Y_train}. The \code{Y_test} values represent
the conditional mean (Fixed + Random Effects) and serve as the ground truth for prediction tasks
aiming to recover the de-noised signal.
}
\examples{
sim_data <- simulation_prediction_conti(
  train_prop = 0.7,
  n_subject = 200,
  n_obs_per_sub = 5,
  nonlinear = TRUE,
  residual = "normal",
  randeff = "skewed_MVN",
  seed = 123
)
}
