% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarker.R
\docType{data}
\name{AL}
\alias{AL}
\title{Alzheimer's disease neuropsychometric marker dataset}
\format{A data frame with 108 observations on the following 12 variables.}
\usage{
data(AL)
}
\description{
The dataset is a subset of the longitudinal cohort of Washington University (WU)
Alzheimer's Disease Research Center (ADRC). In the AL dataset, measurements of 12 neuropsychological markers
were collected on 108 independent individuals of age 75. The individuals were classified into 3 groups based on
published clinical demential rating (CDR).
}
\details{
\itemize{
  \item ktemp. a numeric vector, measurements on the neuropsychometric test for \dQuote{temporal factor}.
  \item kpar. a numeric vector, measurements on the neuropsychometric test for \dQuote{parietal factor}.
  \item kfront. a numeric vector, measurements on the neuropsychometric test for \dQuote{frontal factor}.
  \item zpsy005. a numeric vector, measurements on the neuropsychometric test for \dQuote{digital span forward}.
  \item zpsy006. a numeric vector, measurements on the neuropsychometric test for \dQuote{digital span backward}.
  \item zinfo. a numeric vector, measurements on the neuropsychometric test for \dQuote{information}.
  \item zbentc. a numeric vector, measurements on the neuropsychometric test for \dQuote{visual retention (10s)}.
  \item zbentd. a numeric vector, measurements on the neuropsychometric test for \dQuote{visual retention (copy)}.
  \item zboston. a numeric vector,a numeric vector, measurements on the neuropsychometric test for \dQuote{boston naming}.
  \item zmentcon. a numeric vector,measurements on the neuropsychometric test for \dQuote{mental control}.
  \item zworflu. a numeric vector,measurements on the neuropsychometric test for \dQuote{word fluency}.
  \item zassc. a numeric vector,measurements on the neuropsychometric test for \dQuote{associate learning}.
}
}
\keyword{datasets}
