% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdc_extabs.R
\name{sdc_extabs}
\alias{sdc_extabs}
\alias{print.sdc_extabs}
\alias{plot.sdc_extabs}
\title{Calculate risk measures through exhaustive tabulations, Mu-Argus, and other 
  methods.}
\usage{
sdc_extabs(
  data,
  ID = NULL,
  weight = NULL,
  varpool = names(data),
  forcelist = character(0),
  forcenum = 1,
  missingdef = list(),
  mindim = 1,
  maxdim = 2,
  threshold = NULL,
  wgtthreshold = NULL,
  condition = NULL,
  output_filename = NULL,
  tau1 = 0.2,
  tau2 = 0.2,
  include_mu_argus = TRUE
)

\method{print}{sdc_extabs}(x, cutoff = 50, summary_outfile = NULL, ...)

\method{plot}{sdc_extabs}(x, plotpath = NULL, plotvar1 = character(0), plotvar2 = character(0), ...)
}
\arguments{
\item{data}{Data frame containing the data for which we are to measure 
disclosure risk. Unexpected behavior may result if any column name begins
with a period.}

\item{ID}{Name of column which identifies records. If NULL (default), an
ID column named .ROW_NUMBER is created and used in reports.}

\item{weight}{Column name for sampling weights. NULL or empty if none.}

\item{varpool}{Vector of column names over which to form tables.}

\item{forcelist}{Vector of variable names. Some are included in all 
tabulations. Optional.}

\item{forcenum}{Number of variables in \code{forcelist} that are mandatory for 
all tabulations. That is, all tabulations will have a number of variables
from forcelist exactly equal to \code{forcenum}.}

\item{missingdef}{A named list specifying missing values. The names
correspond to column names in \code{data}.}

\item{mindim}{Integer specifying the minimum number of \code{varpool} variables 
(including \code{forcelist} variables) that can be used to form tables.}

\item{maxdim}{Integer specifying the maximum number of \code{varpool} variables
(including ]code{forcelist} variables) that can be used to form tables.}

\item{threshold}{Threshold to determine the number of violations in terms of 
cell counts. If the number of cases in a cell is less than \code{threshold}, 
the cell is flagged as a violation. If threshold is NULL and wgthreshold is
not NULL, then only a weighted threshold will be used. If both are NULL,
threshold will be set to 3 and the weighted threshold will not be used.}

\item{wgtthreshold}{Threshold to determine violations in terms of weighted
cell counts. If NULL, a weighted threshold will not be used.}

\item{condition}{Character string describing how weighted and unweighted
thresholds are combined when both are used. If used, it must be "and" or 
"or" (case insensitive). This parameter is ignored if \code{weight} is NULL.}

\item{output_filename}{Name of the csv file to save the data set with 
violation counts and Mu-Argus scores attached. NULL if no output file is to
be saved.}

\item{tau1}{A threshold to compute the risk measure, pRa. See User Manual for
more details.}

\item{tau2}{A threshold to compute the risk measure, jRa. This parameter is 
ignored if \code{weight} is NULL. See User Manual for more details.}

\item{include_mu_argus}{Flag indicating whether Mu-Argus and El-Emam 
metrics should be calculated.}

\item{x}{An object of class \code{sdc_extabs}, as returned by the 
\code{\link{sdc_extabs}} function.}

\item{cutoff}{The number of variable categories with the highest percentage 
of cell violations for each table dimension. Default is
50.}

\item{summary_outfile}{Name of summary output .txt file. If not NULL, console
output is copied to the file. Default is NULL (no logging of output).
Errors and warnings are not diverted (consider running in batch mode if
logging of errors and warnings is needed).}

\item{...}{Currently unused. For NextMethod compatibility.}

\item{plotpath}{Directory to save plots. Plots are saved as \emph{jpeg} files 
(quality = 100\%). If the directory does not exist, it is first created.
If \code{plotpath} is NULL (default), plots are not saved.}

\item{plotvar1}{A vector of names of discrete variables for boxplots. If 
none, boxplots are not produced.}

\item{plotvar2}{A vector of names of continuous variables for scatterplots. 
If none, scatterplots are not produced.}
}
\value{
An object of type \code{sdc_extabs}. Internally, a named list of 
  statistics.
\describe{
  \item{\emph{tabulation}}{Cell counts and violation flags. Represented as
     a list with each element corresponding to a \code{varpool} combination.}
  \item{\emph{data_with_statistics}}{The original data with new 
        columns showing statistics such as violation counts and Mu-Argus 
        score for each record.}
  \item{\emph{recoded_data_with_statistics}}{Same as 
     \code{data_with_statistics} but with missing value recodes.}
  \item{\emph{mu_argus_summary}}{Summary table of Mu-Argus by cell count. For
     this summary, all variables in \code{varpool} are used to define a cell. If
     weight is NULL, then this summary is omitted.}
  \item{\emph{el_emam_measures}}{List of file-level re-identification risk 
    measures.}
  \item{\emph{percent_violations_by_var_and_level}}{Table with percent of
     records that are in violation for each variable/category.}
  \item{\emph{percent_violations_by_dim_var_and_level}}{Table with percent 
     of cells that are in violation for each dimension/variable/category.}
  \item{\emph{options}}{Options provided to \code{sdc_extabs} by the user, 
     such as \code{missingdef}, \code{mindim}, etc.}
}
}
\description{
This function primarily uses the exhaustive tabulation method to quantify 
disclosure risk. It tabulates cell counts for different combinations of 
variables provided by the user. Using these counts, this function identifies
variable categories and records which are considered high risk for
disclosure. File-level re-identification risk measures are also provided, 
e.g., Mu-Argus (Polettini 2003) and the risk metrics promosed in El Emam 
(2011).
}
\details{
If a specified missing value contains
  only whitespace, it will match any element with only whitespace. NA values
  in data are treated as missing regardless of \code{missingdef}. If you do not
  want NA values to be treated as missing, please recode them before
  passing the data to this function.

  Note that if a weight variable is not provided, the number of statistics
  and plots that are produced is significantly reduced.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: S3 print method for \code{sdc_extabs} objects

Prints a nicely formatted version of the percent record violations by 
variable/category and percent cell violations by dimension/variable/category

\item \code{plot}: S3 plot method for \code{sdc_extabs} objects

Produces boxplots and scatterplots of violation counts and mu-argus scores.
}}

\examples{
data(exampledata)
vars <- c("BIB1201", "BIC0501", "BID0101", "BIE0601", "BORNUSA", "CENREG",
          "DAGE3", "DRACE3", "EDUC3", "GENDER")
results <- sdc_extabs(exampledata, 
                      ID="CASEID",
                      weight="WEIGHT", 
                      varpool=vars,
                      mindim=2,
                      maxdim=3,
                      missingdef=list(BIE0601=5),
                      wgtthreshold=3000,
                      condition="or")
print(results, cutoff=15)
plot(results, plotvar1="BORNUSA", plotvar2="WEIGHT")
}
\references{
\insertRef{el2011methods}{SDCNway}

\insertRef{polettini2003some}{SDCNway}
}
