% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDIGA.R
\name{SDIGA}
\alias{SDIGA}
\title{Subgroup Discovery Iterative Genetic Algorithm (SDIGA)}
\usage{
SDIGA(parameters_file = NULL, training = NULL, test = NULL,
  output = c("optionsFile.txt", "rulesFile.txt", "testQM.txt"), seed = 0,
  nLabels = 3, nEval = 10000, popLength = 100, mutProb = 0.01,
  RulesRep = "can", Obj1 = "CSUP", w1 = 0.7, Obj2 = "CCNF", w2 = 0.3,
  Obj3 = "null", w3 = 0, minConf = 0.6, lSearch = "yes",
  targetVariable = NA, targetClass = "null")
}
\arguments{
\item{parameters_file}{The path of the parameters file. \code{NULL} If you want to use training and test \code{SDEFSR_Dataset} variables}

\item{training}{A \code{SDEFSR_Dataset} class variable with training data.}

\item{test}{A \code{SDEFSR_Dataset} class variable with training data.}

\item{output}{character vector with the paths of where store information file, rules file and test quality measures file, respectively.}

\item{seed}{An integer to set the seed used for generate random numbers.}

\item{nLabels}{Number of linguistic labels that represents numerical variables.}

\item{nEval}{An integer for set the maximum number of evaluations in the evolutive process.}

\item{popLength}{An integer to set the number of individuals in the population.}

\item{mutProb}{Sets the mutation probability. A number in [0,1].}

\item{RulesRep}{Representation used in the rules. "can" for canonical rules, "dnf" for DNF rules.}

\item{Obj1}{Sets the Objective number 1. See \code{Objective values} for more information about the possible values.}

\item{w1}{Sets the weight of \code{Obj1}.}

\item{Obj2}{Sets the Objective number 2. See \code{Objective values} for more information about the possible values.}

\item{w2}{Sets the weight of \code{Obj2}.}

\item{Obj3}{Sets the Objective number 3. See \code{Objective values} for more information about the possible values.}

\item{w3}{Sets the weight of \code{Obj3}.}

\item{minConf}{Sets the minimum confidence that must have the rule returned by the genetic algorithm after the local optimitation phase. A number in [0,1].}

\item{lSearch}{Sets if the local optimitation phase must be performed. A string with "yes" or "no".}

\item{targetVariable}{A string with the name or an integer with the index position of the target variable (or class). It must be a categorical one.}

\item{targetClass}{A string specifing the value the target variable. \code{null} for search for all possible values.}
}
\value{
The algorithm shows in the console the following results:
\enumerate{
 \item The parameters used in the algorithm
 \item The rules generated.
 \item The quality measures for test of every rule and the global results.
}

    Also, the algorithms save those results in the files specified in the \code{output} parameter of the algorithm or 
    in the \code{outputData} parameter in the parameters file.
}
\description{
Perfoms a subgroup discovery task executing the algorithm SDIGA
}
\details{
This function sets as target variable the last one that appear in \code{SDEFSR_Dataset} object. If you want 
    to change the target variable, you can set the \code{targetVariable} to change this target variable.
    The target variable MUST be categorical, if it is not, throws an error. Also, the default behaviour is to find
    rules for all possible values of the target varaible. \code{targetClass} sets a value of the target variable where the
    algorithm only finds rules about this value.
    
    If you specify in \code{paramFile} something distinct to \code{NULL} the rest of the parameters are
    ignored and the algorithm tries to read the file specified. See "Parameters file structure" below 
    if you want to use a parameters file.
}
\section{How does this algorithm work?}{

    This algorithm has a genetic algorithm in his core. This genetic algorithm returns only the best
    rule of the population and it is executed so many times until a stop condition is reached. The stop condition is 
    that the rule returned must cover at least one new example (not covered by previous rules) and must have a confidence
    greater than a minimum.
    
   After returning the rule, a local improvement could be applied for make the rule more general. This local improve is done
   by means of a hill-climbing local search.
   
   The genetic algorithm cross only the two best individuals. But the mutation operator is applied over all the population,
   individuals from cross too.
}

\section{Parameters file structure}{

  The \code{parameters_file} argument points to a file which has the necesary parameters for SDIGA works.
  This file \strong{must} be, at least, those parameters (separated by a carriage return):
  \itemize{
    \item \code{algorithm}  Specify the algorithm to execute. In this case. "SDIGA"
    \item \code{inputData}  Specify two paths of KEEL files for training and test. In case of specify only the name of the file, the path will be the working directory.
    \item \code{seed}  Sets the seed for the random number generator
    \item \code{nLabels}  Sets the number of fuzzy labels to create when reading the files
    \item \code{nEval}  Set the maximun number of \strong{evaluations of rules} for stop the genetic process
    \item \code{popLength}  Sets number of individuals of the main population
    \item \code{mutProb}  Mutation probability of the genetic algorithm. Value in [0,1]
    \item \code{RulesRep}  Representation of each chromosome of the population. "can" for canonical representation. "dnf" for DNF representation.
    \item \code{Obj1} Sets the objective number 1. 
    \item \code{w1} Sets the weigth assigned to the objective number 1. Value in [0,1]
    \item \code{Obj2} Sets the objective number 2. 
    \item \code{w2} Sets the weigth assigned to the objective number 2. Value in [0,1]
    \item \code{Obj3} Sets the objective number 3. 
    \item \code{w3} Sets the weigth assigned to the objective number 3. Value in [0,1]
    \item \code{minConf} Sets the minimum confidence of the rule for checking the stopping criteria of the iterative process
    \item \code{lSearch} Perform the local search algorithm after the execution of the genetic algorithm? Values: "yes" or "no"
    \item \code{targetVariable} The name or index position of the target variable (or class). It must be a categorical one.
    \item \code{targetClass}  Value of the target variable to search for subgroups. The target variable \strong{is always the last variable.}. Use \code{null} to search for every value of the target variable
  }
  
  An example of parameter file could be:
 \preformatted{
algorithm = SDIGA
inputData = "irisD-10-1tra.dat" "irisD-10-1tst.dat"
outputData = "irisD-10-1-INFO.txt" "irisD-10-1-Rules.txt" "irisD-10-1-TestMeasures.txt"
seed = 0
nLabels = 3
nEval = 500
popLength = 100
mutProb = 0.01
minConf = 0.6
RulesRep = can
Obj1 = Comp
Obj2 = Unus
Obj3 = null
w1 = 0.7
w2 = 0.3
w3 = 0.0
lSearch = yes
}
}

\section{Objective values}{

     You can use the following quality measures in the ObjX value of the parameter file using this values:
      \itemize{
        \item Unusualness -> \code{unus}
        \item Crisp Support -> \code{csup}
        \item Crisp Confidence -> \code{ccnf}
        \item Fuzzy Support -> \code{fsup}
        \item Fuzzy Confidence -> \code{fcnf}
        \item Coverage -> \code{cove}
        \item Significance -> \code{sign}
      }
    
    If you dont want to use a objetive value you must specify \code{null}
}
\examples{
SDIGA(parameters_file = NULL, 
      training = habermanTra, 
      test = habermanTst, 
      output = c("optionsFile.txt", "rulesFile.txt", "testQM.txt"),
      seed = 0, 
      nLabels = 3,
      nEval = 300, 
      popLength = 100, 
      mutProb = 0.01, 
      RulesRep = "can",
      Obj1 = "CSUP", 
      w1 = 0.7,
      Obj2 = "CCNF",
      w2 = 0.3,
      Obj3 = "null",
      w3 = 0,
      minConf = 0.6,
      lSearch = "yes",
      targetClass = "positive")
\dontrun{
SDIGA(parameters_file = NULL, 
      training = habermanTra, 
      test = habermanTst, 
      output = c("optionsFile.txt", "rulesFile.txt", "testQM.txt"),
      seed = 0, 
      nLabels = 3,
      nEval = 300, 
      popLength = 100, 
      mutProb = 0.01, 
      RulesRep = "can",
      Obj1 = "CSUP", 
      w1 = 0.7,
      Obj2 = "CCNF",
      w2 = 0.3,
      Obj3 = "null",
      w3 = 0,
      minConf = 0.6,
      lSearch = "yes",
      targetClass = "positive")
      }
}
\references{
M. J. del Jesus, P. Gonzalez, F. Herrera, and M. Mesonero, "Evolutionary
Fuzzy Rule Induction Process for Subgroup Discovery: A case study in
marketing," IEEE Transactions on Fuzzy Systems, vol. 15, no. 4, pp.
578-592, 2007.
}

