% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{regPath.SDForest}
\alias{regPath.SDForest}
\alias{regPath}
\title{Calculate the regularization path of an SDForest}
\usage{
\method{regPath}{SDForest}(object, cp_seq = NULL, X = NULL, Y = NULL, Q = NULL, ...)
}
\arguments{
\item{object}{an SDForest object}

\item{cp_seq}{A sequence of complexity parameters.
If NULL, the sequence is calculated automatically using only relevant values.}

\item{X}{The training data, if NULL the data from the forest object is used.}

\item{Y}{The training response variable, if NULL the data from the forest object is used.}

\item{Q}{The transformation matrix, if NULL the data from the forest object is used.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{paths} containing
\item{cp}{The sequence of complexity parameters.}
\item{varImp_path}{A \code{matrix} with the variable importance
for each complexity parameter.}
\item{loss_path}{A \code{matrix} with the out-of-bag performance
for each complexity parameter.}
\item{cp_min}{The complexity parameter with the lowest out-of-bag performance.}
\item{type}{Path type}
}
\description{
This function calculates the variable importance of an SDForest
and the out-of-bag performance for different complexity parameters.
}
\examples{
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + sign(X[, 2]) + rnorm(n)
model <- SDForest(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
paths <- regPath(model)
plotOOB(paths)
plot(paths)
\donttest{
plot(paths, plotly = TRUE)
}

}
\seealso{
\code{\link{plot.paths}} \code{\link{plotOOB}} \code{\link{regPath.SDTree}} \code{\link{prune}} \code{\link{get_cp_seq}} \code{\link{SDForest}}
}
\author{
Markus Ulmer
}
