% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp.R
\name{varImp.SDAM}
\alias{varImp.SDAM}
\title{Extract Variable importance for SDAM}
\usage{
\method{varImp}{SDAM}(object)
}
\arguments{
\item{object}{an \code{SDAM} object}
}
\value{
A vector of variable importance
}
\description{
This function extracts the variable importance of an SDAM.
The variable importance is calculated as the empirical squared L2 norm of fj. 
The measure is not standardized.
}
\examples{
set.seed(1)
X <- matrix(rnorm(10 * 5), ncol = 5)
Y <- sin(X[, 1]) -  X[, 2] + rnorm(10)
model <- SDAM(x = X, y = Y, Q_type = "trim", trim_quantile = 0.5, nfold = 2)
varImp(model)
}
\seealso{
\code{\link{SDAM}}
}
\author{
Cyrill Scheidegger
}
