% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-SDMmodel.R
\name{predict,SDMmodel-method}
\alias{predict,SDMmodel-method}
\title{Predict}
\usage{
\S4method{predict}{SDMmodel}(
  object,
  data,
  type = NULL,
  clamp = TRUE,
  filename = "",
  format = "GTiff",
  extent = NULL,
  parallel = FALSE,
  progress = "",
  ...
)
}
\arguments{
\item{object}{\linkS4class{SDMmodel} object.}

\item{data}{data.frame, \linkS4class{SWD} or \link[raster]{stack} with the
data for the prediction.}

\item{type}{character. Output type, see details, used only for \strong{Maxent} and
\strong{Maxnet} methods, default is \code{NULL}.}

\item{clamp}{logical for clumping during prediction, used only for \strong{Maxent}
and \strong{Maxnet} methods, default is \code{TRUE}.}

\item{filename}{character. Output file name for the prediction map, used only
when \code{data} is a \link[raster]{stack} object. If provided the output is saved
in a file.}

\item{format}{character. The output format, see \link[raster]{writeRaster}
for all the options, default is "GTiff".}

\item{extent}{\link[raster]{extent} object, if provided it restricts
the prediction to the given extent, default is \code{NULL}.}

\item{parallel}{deprecated.}

\item{progress}{character to display a progress bar: "text", "window" or ""
(default) for no progress bar.}

\item{...}{Additional arguments to pass to the \link[raster]{writeRaster}
function.}
}
\value{
A vector with the prediction or a \link[raster]{raster} object if
data is a raster \link[raster]{stack}.
}
\description{
Predict the output for a new dataset given a trained \linkS4class{SDMmodel}
model.
}
\details{
\itemize{
\item filename, format, extent, progress, and ... are arguments used only when
the prediction is done for a \link[raster]{stack} object.
\item For models trained with the \strong{Maxent} method the argument \code{type} can be:
"raw", "logistic" and "cloglog". The function performs the prediction in
\strong{R} without calling the \strong{MaxEnt} Java software. This results in a faster
computation for large datasets and might result in a slightly different
output compared to the Java software.
\item For models trained with the \strong{Maxnet} method the argument \code{type} can be:
"link", "exponential", "logistic" and "cloglog", see \link[maxnet]{maxnet}
for more details.
\item For models trained with the \strong{ANN} method the function uses the "raw"
output type.
\item For models trained with the \strong{RF} method the output is the probability of
class 1.
\item For models trained with the \strong{BRT} method the function uses the number of
trees defined to train the model and the "response" output type.
}
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", data = train, fc = "l")

# Make cloglog prediction for the test dataset
predict(model, data = test, type = "cloglog")

# Make logistic prediction for the all study area
predict(model, data = predictors, type = "logistic")

\dontrun{
# Make logistic prediction for the all study area and save it in a file
# The function saves the file in your working directory
predict(model, data = predictors, type = "logistic", filename = "my_map")
}
}
\references{
Wilson P.D., (2009). Guidelines for computing MaxEnt model output
values from a lambdas file.
}
\author{
Sergio Vignali
}
