% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphID.R
\name{getMixedCompForNode}
\alias{getMixedCompForNode}
\title{Get the mixed component of a node in a mixed subgraph.}
\usage{
getMixedCompForNode(dG, bG, subNodes, node)
}
\arguments{
\item{dG}{a directed graph representing the directed part of the mixed graph.}

\item{bG}{an undirected graph representing the undirected part of the mixed
graph.}

\item{subNodes}{an ancestral set of nodes in the mixed graph, this set should
include the node for which the mixed component sould be found.}

\item{node}{the node for which the mixed component is found.}
}
\value{
a list with two named elements:
         biNodes - the nodes of the mixed graph in the biDirected component
                   containing nodeName w.r.t the ancestral set of nodes
         inNodes - the nodes in the graph which are not part of biNodes
                   but which are a parent of some node in biNodes.
}
\description{
For an input mixed graph H and set of nodes A, let GA be the subgraph of
H on the nodes A. This function returns the mixed component of GA containing
a specified node.
}

