% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{SEMgsa}
\alias{SEMgsa}
\title{SEM-based gene set analysis}
\usage{
SEMgsa(g = list(), data, group, method = "BH", alpha = 0.05, n_rep = 1000, ...)
}
\arguments{
\item{g}{A list of pathways to be tested.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes (variables).}

\item{group}{A binary vector. This vector must be as long as the number
of subjects. Each vector element must be 1 for cases and 0 for control
subjects.}

\item{method}{Multiple testing correction method. One of the values
available in \code{\link[stats]{p.adjust}}. By default, method is set
to "BH" (i.e., Benjamini-Hochberg correction).}

\item{alpha}{Gene set test significance level (default = 0.05).}

\item{n_rep}{Number of randomization replicates (default = 1000).}

\item{...}{Currently ignored.}
}
\value{
A list of 2 objects:
\enumerate{
\item "gsa", A data.frame reporting the following information for each
pathway in the input list:
\itemize{
\item "N.nodes", pathway size (number of nodes);
\item "N.DRNs", number of differential regulated genes (DRNs) within the pathway,
after multiple test correction with Benjamini-Hochberg method;
\item "pD", significance of the sum of group effects, adjusted by the
residual variance;
\item "pA", significance of the sum of tagret nodes perturbation
(i.e., group effect) accumulation from source nodes;
\item "pE", significance of the sum of source nodes perturbation
(i.e., group effect) emission towards target nodes;
\item "pvalue", Fisher's combined P-value of pD, pA, and pE.
}
\item "DRN", a list with DRNs names per pathways.
}
}
\description{
Gene Set Analysis (GSA) via self-contained test for group
effect on signaling (directed) pathways as SEM, evaluating overall pathway
perturbation, perturbation emission from source nodes, and perturbation
accumulation on target nodes. Approximate randomization test P-values
of specific node and aggregated group effects will be computed.
For directed graphs, they include: the sum of group effects adjusted
by residual variances (D), the sum of the tagret nodes perturbation
(i.e., group effect) accumulation from source nodes (A), and the sum
of the source nodes perturbation emission towards target nodes (E).
For undirected graphs, the sum of group effects (D), adjusted
by residual variances, will be estimated.
}
\examples{

\dontrun{

# Nonparanormal(npn) transformation
library(huge)
als.npn <- huge.npn(alsData$exprs)

# Selection of FTD pathways from kegg.pathways.Rdata

paths.name <- c("MAPK signaling pathway",
                "Protein processing in endoplasmic reticulum",
                "Endocytosis",
                "Wnt signaling pathway",
                "Neurotrophin signaling pathway",
                "Amyotrophic lateral sclerosis")

j <- which(names(kegg.pathways) \%in\% paths.name)

GSA <- SEMgsa(kegg.pathways[j], als.npn, alsData$group,
              method = "bonferroni", alpha = 0.05,
              n_rep = 1000)
GSA$gsa
GSA$DRN

}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
