% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semCluster.R
\name{factor.analysis}
\alias{factor.analysis}
\title{Factor analysis for high dimensional data}
\usage{
factor.analysis(Y, r = 1, method = "pc")
}
\arguments{
\item{Y}{data matrix, a n*p matrix}

\item{r}{number of factors (default, r =1)}

\item{method}{algorithm to be used (default, method = "pc")}
}
\value{
a list of objects
\describe{
\item{Gamma}{estimated factor loadings}
\item{Z}{estimated latent factors}
\item{Sigma}{estimated noise variance matrix}
}
}
\description{
Wrapper for Factor Analysis with potentially high dimensional variables 
implement in the "cate" R package (Author: Jingshu Wang [aut], Qingyuan Zhao [aut, cre]
Maintainer: Qingyuan Zhao <qz280@cam.ac.uk>) that is optimized for the high dimensional
problem where the number of samples n is less than the number of variables p.
}
\details{
The two methods extracted from "cate" are quasi-maximum likelihood (ml), and
principal component analysis (pc). The ml is iteratively solved the EM algorithm
using the PCA solution as the initial value. See Bai and Li (2012) for more details.
}
\examples{

library(huge)
als.npn <- huge.npn(alsData$exprs)

## pc
pc<- factor.analysis(Y = als.npn, r = 2, method = "pc")
head(pc$Gamma)
head(pc$Z)
head(pc$Sigma)

## ml
ml <- factor.analysis(Y = als.npn, r = 2, method = "ml")
head(ml$Gamma)
head(ml$Z)
head(ml$Sigma)

}
\references{
{
Bai, J. and Li, K. (2012). Statistical analysis of factor models of high dimension.
\emph{The Annals of Statistics 40}, 436-465.
}
}
