% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huber.reg.adaptive.skew.R
\name{huber.reg.adaptive.skew}
\alias{huber.reg.adaptive.skew}
\title{Adaptive Huber Regression for Skew Factor Models}
\usage{
huber.reg.adaptive.skew(
  X,
  Y,
  tau = 1.35,
  max_iterations = 100,
  tolerance = 1e-06,
  n_factors = 1
)
}
\arguments{
\item{X}{A matrix of predictor variables.}

\item{Y}{A vector of response variables.}

\item{tau}{Initial robustification parameter (default is 1.35).}

\item{max_iterations}{Maximum number of iterations (default is 100).}

\item{tolerance}{Convergence tolerance (default is 1e-6).}

\item{n_factors}{The number of factors (columns) for the loading matrix (default is 1).}
}
\value{
A matrix of estimated regression coefficients with dimensions `p x n_factors`.
}
\description{
Performs adaptive Huber regression tailored for skew factor models, 
and returns the estimated regression coefficients in a matrix (loading matrix) format.
}
\examples{
# Generate some example data for skew factor models
set.seed(123)
n <- 200
d <- 10
beta <- rep(1, d)
skew_factor <- rnorm(n)  # Adding a skew factor
X <- matrix(rnorm(n * d), n, d)
err <- rnorm(n)
Y <- 1 + skew_factor + X \%*\% beta + err

# Perform adaptive Huber regression for skew factor model
loading_matrix <- huber.reg.adaptive.skew(X, Y, n_factors = 3)
print(loading_matrix)

}
