% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicitHeterogeneity.R
\name{elicitHeterogen}
\alias{elicitHeterogen}
\title{Elicit a prior distribution for a random effects variance parameter}
\usage{
elicitHeterogen(lower = 1, upper = 10, gridheight = 10, nbins = 9,
  scale.free = TRUE, sigma = 1)
}
\arguments{
\item{lower}{The lower limit on the x-axis of the roulette grid.}

\item{upper}{The upper limit on the x-axis of the roulette grid.}

\item{gridheight}{The maximum number of probs that can be allocated to a
single bin.}

\item{nbins}{The number of equally sized bins drawn between \code{lower} and
\code{upper}.}

\item{scale.free}{Logical. Default is \code{TRUE} for a scale free treatment effect,
such as an odds ratio, hazard ratio or relative risk. Set to \code{FALSE} for a treatment effect
that is scale dependent, or is on the probit scale. An approximation to the treatment effect
on the logit scale will be used (assuming a dichotomised response).}

\item{sigma}{Individual observation standard deviation, required if \code{scale.free} is
\code{FALSE}.}
}
\value{
BUGS code for incorporating the prior within a BUGS model. Additionally, a list with outputs 
\item{allocation }{table of bins, with number of probs allocated to each bin.}
\item{Gamma }{parameters of the fitted gamma distribution.}
\item{Log.normal }{parameters of the fitted lognormal distribution.}
\item{sumsq }{sum of squares of elicited - fitted probabilities for each distribution.}
\item{best.fitting}{the distribution with the lowest sum of squares.}
}
\description{
Opens a shiny app for the roulette elicitation method. The user clicks in the
grid to allocate 'probs' to 'bins'. The elicited probability inside each
bin is the proportion of probs in each bin. This will fit a distribution to the ratio R
of the 'largest' (97.5th percentile) to 'smallest' (2.5th percentile) treatment effect. 
A distribution for the variance effects variance parameter is inferred from the distribution 
of R, assuming that the random effects are normally distributed.
}
\note{
Regarding the option ``spread end probs over empty bins'' 
(unchecked as the default): suppose for example, the leftmost and rightmost non-empty
bins are [10,20] and [70,80], and each contain one prob, with 20 probs used in total. If the option
is unchecked, it is assumed P(X<20) = P(X>70) = 0.05 and P(X<10) = P(X>80) = 0. If the option
is checked, it is assumed P(X<20) = P(X>70) = 0.05 only.
}
\examples{

\dontrun{
elicitHeterogen()
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
