% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfplots.R
\name{pdfplots}
\alias{pdfplots}
\title{Plot fitted population pdfs}
\usage{
pdfplots(medianfit, precisionfit, alpha = 0.05, tails = 0.05,
  lower = NA, upper = NA, n.x = 100, d = "best", fontsize = 18)
}
\arguments{
\item{medianfit}{The output of a \code{fitdist} command following elicitation
of the expert's beliefs about the population median.}

\item{precisionfit}{The output of a \code{fitdist} command following elicitation
of the expert's beliefs about the population precision.}

\item{alpha}{Value between 0 and 1 to determine choice of means and variances used in plots}

\item{tails}{Value between 0 and 1 to determine the tail area shown in the pdf plots}

\item{lower}{lower limit on the x-axis for plotting.}

\item{upper}{upper limit on the x-axis for plotting.}

\item{n.x}{The number of points on the x-axis at which the pdf is plotted.}

\item{d}{The fitted distribution for the population median. Can be one of "normal",
"lognormal" or "best", where "best" will select the best fitting out of 
normal and lognormal.}

\item{fontsize}{Font size used in the plots.}
}
\value{
A plot and a list, containing
\item{mu}{The two population mean values used in the plots.}
\item{sigma}{The two population standard deviation values used in the plots.}
}
\description{
Plot fitted population pdfs at combinations of two different values of the population mean and variance.
}
\details{
Four pdfs are plotted, using each combination of the \code{alpha}/2 and 1-\code{alpha}/2
quantiles of the fitted distributions for the population median and standard deviation
}
\examples{
\dontrun{
prfit <- fitprecision(interval = c(60, 70), propvals = c(0.2, 0.4), trans = "log")
medianfit <- fitdist(vals = c(50, 60, 70), probs = c(0.05, 0.5,  0.95), lower = 0)
pdfplots(medianfit, prfit, alpha = 0.01)
 }
}
\references{
\code{multiplot} function obtained from
 \url{http://www.cookbook-r.com/Graphs/Multiple_graphs_on_one_page_(ggplot2)/}
}
