% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxLikOverlap.R
\name{maxLikOverlap}
\alias{maxLikOverlap}
\title{Calculate the overlap between two ellipses based on the maximum likelihood 
fitted ellipses.}
\usage{
maxLikOverlap(ellipse1, ellipse2, siber.object, p.interval = 0.95,
  n = 100, do.plot = FALSE)
}
\arguments{
\item{ellipse1}{character code of the form \code{"x.y"} where \code{x} is an 
integer indexing the community, and \code{y} an integer indexing the group 
within that community. This specifies the first of two ellipses whose 
overlap will be compared.}

\item{ellipse2}{same as \code{ellipse1} specifying a second ellipse.}

\item{siber.object}{an object created by  \code{\link{createSiberObject}} 
which contains the ML estimates for the means and covariance matrices for 
each group.}

\item{p.interval}{the prediction interval used to scale the ellipse as per 
\code{\link{addEllipse}}.}

\item{n}{the number of points on the edge of the ellipse used to define it. 
Defaults to \code{100} as per \code{\link{addEllipse}}.}

\item{do.plot}{logical switch to determine whether the corresponding ellipses
should be plotted or not. A use-case would be in conjunction with a low 
numbered \code{draws} so as to visualise a relatively small number of the 
posterior ellipses. Defaults to \code{FALSE}.}
}
\value{
A vector comprising three columns: the area of overlap, the area of 
  the first ellipse and the area of the second ellipse and as many rows as 
  specified by \code{draws}.
}
\description{
This function uses the ML estimated means and covariances matrices of two 
specified groups to calculate the area of overlap.
}
\examples{
# load in the included demonstration dataset data("demo.siber.data")
siber.example <- createSiberObject(demo.siber.data) 

# The first ellipse is referenced using a character string representation 
# where in "x.y", "x" is the community, and "y" is the group within that 
# community.
ellipse1 <- "1.2" 

# Ellipse two is similarly defined: community 1, group3 
ellipse2 <- "1.3"

# the overlap betweeen the corresponding 95\% prediction ellipses is given by: 
ellipse95.overlap <- maxLikOverlap(ellipse1, ellipse2, siber.example,
p.interval = 0.95, n = 100)

}
