% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridgeSIR.R
\name{tune}
\alias{tune}
\alias{tune.ridgeSIR}
\title{Cross-Validation for ridge SIR}
\usage{
tune(x, y, listH, list_mu2, list_d, nfolds, parallel, ncores)

\method{tune}{ridgeSIR}(
  x,
  y,
  listH,
  list_mu2,
  list_d,
  nfolds = 10,
  parallel = TRUE,
  ncores = NULL
)
}
\arguments{
\item{x}{explatory variables (numeric matrix or data frame)}

\item{y}{target variable (numeric vector)}

\item{listH}{list of the number of slices to be tested (numeric vector)}

\item{list_mu2}{list of ridge regularization parameters to be tested 
(numeric vector)}

\item{list_d}{list of the dimensions to be tested (numeric vector)}

\item{nfolds}{number of folds for the cross validation. Default is 10}

\item{parallel}{whether the computation should be performed in parallel or
not. Logical. Default is FALSE}

\item{ncores}{number of cores to use if \code{parallel = TRUE}. If left to 
NULL, all available cores minus one are used}
}
\value{
a data frame with tested parameters and corresponding CV error and 
estimation of R(d)
}
\description{
\code{tune.ridgeSIR} performs a Cross Validation for ridge SIR estimation
}
\examples{
set.seed(1115)
tsteps <- seq(0, 1, length = 200)
nsim <- 100
simulate_bm <- function() return(c(0, cumsum(rnorm(length(tsteps)-1, sd=1))))
x <- t(replicate(nsim, simulate_bm()))
beta <- cbind(sin(tsteps*3*pi/2), sin(tsteps*5*pi/2))
y <- log(abs(x \%*\% beta[ ,1])) + sqrt(abs(x \%*\% beta[ ,2]))
y <- y + rnorm(nsim, sd = 0.1)
list_mu2 <- 10^(0:10)
listH <- c(5, 10)
list_d <- 1:4
set.seed(1129)
\dontrun{
res_tune <- tune.ridgeSIR(x, y, listH, list_mu2, list_d, 
                          nfolds = 10, parallel = TRUE)}

}
\references{
{Picheny, V., Servien, R. and Villa-Vialaneix, N. (2016) 
Interpretable sparse SIR for digitized functional data.
\emph{Statistics and Computing}, \strong{29}(2), 255--267.}
}
\seealso{
\code{\link{ridgeSIR}}
}
\author{
{Victor Picheny, \email{victor.picheny@inrae.fr}\cr
Remi Servien, \email{remi.servien@inrae.fr}\cr
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}}
}
