% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/S3_Entropy.R
\name{entropy.matrix}
\alias{entropy.matrix}
\alias{relative.entropy.matrix}
\alias{cross.entropy.matrix}
\alias{entropy}
\alias{relative.entropy}
\alias{cross.entropy}
\title{Entropy}
\usage{
\method{entropy}{matrix}(pk, dim = 0L, base = -1, ...)

\method{relative.entropy}{matrix}(pk, qk, dim = 0L, base = -1, ...)

\method{cross.entropy}{matrix}(pk, qk, dim = 0L, base = -1, ...)

## Generic S3 method
entropy(
 pk,
 dim  = 0,
 base = -1,
 ...
)

## Generic S3 method
relative.entropy(
 pk,
 qk,
 dim  = 0,
 base = -1,
 ...
)

## Generic S3 method
cross.entropy(
 pk,
 qk,
 dim  = 0,
 base = -1,
 ...
)
}
\arguments{
\item{pk}{A \eqn{n \times k} <\link{numeric}>-matrix of observed probabilities.
The \eqn{i}-th row should sum to 1 (i.e., a valid probability distribution
over the \eqn{k} classes). The first column corresponds to the first factor
level in \code{actual}, the second column to the second factor level, and so on.}

\item{dim}{An <\link{integer}> value of \link{length} 1 (Default: 0). Defines the dimension along which to calculate the entropy (0: total, 1: row-wise, 2: column-wise).}

\item{base}{A <\link{numeric}> value of \link{length} 1 (Default: -1). The logarithmic base to use. Default value specifies natural logarithms.}

\item{...}{Arguments passed into other methods}

\item{qk}{A \eqn{n \times k} <\link{numeric}>-matrix of predicted probabilities.
The \eqn{i}-th row should sum to 1 (i.e., a valid probability distribution
over the \eqn{k} classes). The first column corresponds to the first factor
level in \code{actual}, the second column to the second factor level, and so on.}
}
\value{
A <\link{numeric}> value or vector:
\itemize{
\item A single <\link{numeric}> value (length 1) if \code{dim == 0}.
\item A <\link{numeric}> vector with length equal to the \link{length} of rows if \code{dim == 1}.
\item A <\link{numeric}> vector with length equal to the \link{length} of columns if \code{dim == 2}.
}
}
\description{
The \code{\link[=entropy]{entropy()}} function calculates the \strong{Entropy} of given probability distributions.
}
\section{Definition}{


\strong{Entropy:}
\deqn{H(pk) = -\sum_{i} pk_i \log(pk_i)}{H(pk) = -∑ pk_i log(pk_i)}

\strong{Cross Entropy:}
\deqn{H(pk, qk) = -\sum_{i} pk_i \log(qk_i)}{H(pk, qk) = -∑ pk_i log(qk_i)}

\strong{Relative Entropy}
\deqn{D_{KL}(pk \parallel qk) = \sum_{i} pk_i \log\left(\frac{pk_i}{qk_i}\right)}{D_KL(pk || qk) = ∑ pk_i log(pk_i / qk_i)}
}

\examples{
# 1) Define actual
# and observed probabilities

# 1.1) actual probabilies
pk <- matrix(
  cbind(1/2, 1/2),
  ncol = 2
)

# 1.2) observed (estimated) probabilites
qk <- matrix(
  cbind(9/10, 1/10), 
  ncol = 2
)

# 2) calculate
# Entropy
cat(
  "Entropy", entropy(
    pk
  ),
  "Relative Entropy", relative.entropy(
    pk,
    qk
  ),
  "Cross Entropy", cross.entropy(
    pk,
    qk
  ),
  sep = "\n"
)
}
\seealso{
Other Classification: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fmi.factor}()},
\code{\link{fpr.factor}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mcc.factor}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{recall.factor}()},
\code{\link{roc.auc.matrix}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}

Other Supervised Learning: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ccc.numeric}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fpr.factor}()},
\code{\link{huberloss.numeric}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mcc.factor}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{pinball.numeric}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{rae.numeric}()},
\code{\link{recall.factor}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{roc.auc.matrix}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}
}
\concept{Classification}
\concept{Supervised Learning}
