% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_SortingOrdering.R
\name{preorder}
\alias{preorder}
\title{Preorder}
\usage{
preorder(
 x,
 decreasing = FALSE,
 ...
)
}
\arguments{
\item{x}{a \link{numeric} or \link{integer} matrix to be sorted.}

\item{decreasing}{a \link{logical} value of \link{length} 1 (default: \link{FALSE}). If \link{TRUE} the matrix is returned in descending order.}

\item{...}{Arguments passed into other methods.}
}
\value{
A \link{matrix} with indices to the ordered values.
}
\description{
This function does a column-wise ordering permutation of \link{numeric} or \link{integer} matrix.
}
\examples{
# 1) generate a 4x4 matrix
# with random values to be sorted
set.seed(1903)
X <- matrix(
  data = cbind(sample(16:1)),
  nrow = 4
)

# 2) sort matrix
# in decreasing order
presort(X)

# 3) get indices 
# for sorted matrix
preorder(X)
}
\seealso{
Other Tools: 
\code{\link{auc.numeric}()},
\code{\link{cov.wt.matrix}()},
\code{\link{presort}()}
}
\concept{Tools}
