% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{survcell}
\alias{survcell}
\title{survcell}
\usage{
survcell(gene, mutcell, cellmatrix, surv, method = "Multivariate")
}
\arguments{
\item{gene}{Somatic mutant gene name}

\item{mutcell}{The result of `mutcorcell` function}

\item{cellmatrix}{Cell abundance matrix}

\item{surv}{Surv is the survival data, the first column is the sample name, the second column is the survival time, and the third is the survival event.}

\item{method}{Method must be one of "Univariate" and "Multivariate". The coefficient of cells for risk score are estimated by "Univariate" or "Multivariate" cox proportional risk regression model on cell abundance matrix and overall survival data..}
}
\value{
Kaplan–Meier curves
}
\description{
Function `survcell` draws Kaplan–Meier curves for survival in the above-median and below-median groups for cell risk score. The cell risk score is calaulated by the weighted mean of cells driven by a gene mutation, where the  weight of cells is estimated by the "Univariate" or "Multivariate" cox.
}
\examples{
mutcell<-GetExampleData("mutcell") # The result of `mutcorcell` function.
cellmatrix<-GetExampleData("cellmatrix") # Cell abundance matrix
surv<-GetExampleData("surv") # The survival data
survcell(gene ="TP53",mutcell=mutcell,cellmatrix=cellmatrix,surv=surv)
}
