% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeLine.R
\name{timeLine}
\alias{timeLine}
\title{timeLine}
\usage{
timeLine(
  data,
  title,
  color = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{a data.frame that reprensent hosts status in time with ID, status and time in columns}

\item{title}{a tttle as character}

\item{color}{list of color for timeline elements}

\item{width}{numeric width for the area in pixels.}

\item{height}{numeric hieght for the area in pixels.}

\item{elementId}{the element ID where is draw}
}
\description{
Draw a host time line.
Time use timestamp or Date in ISO format.
}
\examples{
library(SMITIDvisu)
data(hostline)
tl <- timeLine(hostline,
               title="Example host 113",
               color=list("infected"="red","offspring"="green",
                             "alive"="blue","inf"="orange",
                             "dead"="black","Obs"="purple"))
\dontrun{
## export as standalone html file
htmlwidgets::saveWidget(tl, "timeline.html")
browseURL("timeline.html")
}

}
