% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gen_Data.R
\name{Gen_Data}
\alias{Gen_Data}
\title{Data simulator for high-dimensional GLMs}
\usage{
Gen_Data(n = 200, p = 5000, num_ctgidx = NULL, pos_ctgidx = NULL,
  num_truecoef = NULL, pos_truecoef = NULL, correlation = c("ID",
  "AR", "MA", "CS"), rho = 0.5, family = c("gaussian", "binomial",
  "poisson"))
}
\arguments{
\item{n}{Sample size, number of rows of the data.frame (or matrix).}

\item{p}{Number of features.}

\item{num_ctgidx}{The number of features that are categorical. Set to FALSE for only numerical features. Default is FALSE.}

\item{pos_ctgidx}{Vector of indices denoting which columns are categorical.}

\item{num_truecoef}{The number of features that affect response. Default is 5.}

\item{pos_truecoef}{Vector of indices denoting which columns affect the response variable.}

\item{correlation}{correlation structure between features. \code{correlation = 'ID'} for all variables independent,
\code{correlation = 'MA'} for moving average, \code{correlation = 'CS'} for compound symmetry, \code{correlation = 'AR'} for auto correlation. Default is "independent".
For more information see details.}

\item{rho}{Parameter for AR(1) data, when correlation = "AR". Default is 0.5.}

\item{family}{Response type.
\code{'gaussian'} for normally distributed data, \code{'poisson'} for non-negative counts,
\code{'binomial'} for binary (0-1).}
}
\value{
Returns a \code{"sdata"} object with
\item{Y}{Response variable vector of length \eqn{n}}
\item{X}{Feature matrix or Dataframe (Matrix if \code{num_ctgidx =FALSE} and dataframe otherwise)}
\item{index}{Vector of columns indices of X for the features that affect the response variables (causal features).}
\item{Beta}{Vector of effects for the causal features.}
}
\description{
This function generates synthetic datasets from GLMs with a user-specified correlation structure.
It permits both numerical and categorical features, whose quantity can be larger than the sample size.
}
\details{
Simulated data \eqn{(y_i , x_i)} for \eqn{i = 1, . . . , n} are generated as follows:
First, randomly sample \code{num_truecoef} important features among the \code{p} features, the magnitude of the effects from a U(0,1) and the sign of the effect randomly(\eqn{\beta}'s).
Second, generate X using theselected correlation structure (independent,  auto-regressive, moving average, compound symmetry). Then, to generating categorical data, we convert numerical
features to categorical by binning value. We randomly select num_ctgixdx numerical columns and convert them into a four level factor.

Moving average: candidate features \eqn{x_1,..., x_p} are joint normal,
marginally N(0, 1), with \eqn{cov(x_j, x_{j-1}) = \frac{2}{3}}, \eqn{cov(x_j, x_{j-2}) = \frac{1}{3}} and \eqn{cov(x_j, x_h) = 0} for \eqn{|j-h| \geq 3}.

Compound symmetry: candidate features \eqn{x_1,..., x_p} are joint normal, marginally N(0, 1), with \eqn{cov(x_j, x_h) =0.15} if \eqn{\ j\ ,\ h\ } are both in the set of important features and \eqn{cov(x_j, x_h) = 0.3} when only
one of \eqn{j} or \eqn{h} are in the set of important features.

Auto-regressive: candidate features \eqn{x_1,..., x_p} are joint normal marginally N(0, 1), with \eqn{cov(x_j, x_{j+1}) = \rho} for all \eqn{j}.

Then, generate the response variable Y according to its response type. For Gaussian model, \eqn{Y =x^T \cdot \beta + \epsilon} where \eqn{\epsilon \in N(0,1)}.
For the binary model let \eqn{\pi = P(Y = 1|x)}. Sample y from Bernoulli(\eqn{\pi}) where \eqn{logit(\pi) = x^T \cdot\beta}.
Finally, for the Poisson model, Y is generated from Poisson distribution with the link \eqn{\pi =exp(x^T \cdot \beta )}. For more details (see reference below)
}
\examples{
#Simulating data with binomial response and independent strcture.
Data<-Gen_Data(family ="binomial",correlation = "ID")
cor(Data$X[,1:5])
print(Data)


}
\references{
Chen Xu and Jiahua Chen. (2014),
The Sparse MLE for Ultrahigh-Dimensional Feature Screening
* Journal of the American Statistical Association*109:507,
pages:1257-1269
}
