% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smle_predict.R
\name{smle_predict}
\alias{smle_predict}
\alias{smle_predict.selection}
\alias{smle_predict.smle}
\alias{smle_predict.default}
\title{Predict method for SMLE screening and selection}
\usage{
smle_predict(x, ...)

\method{smle_predict}{selection}(x, type = c("link", "response", "terms"), terms = NULL, ...)

\method{smle_predict}{smle}(x, type = c("link", "response", "terms"), terms = NULL, ...)

\method{smle_predict}{default}(x, ...)
}
\arguments{
\item{x}{Objects of \code{'smle'} object, as the output from SMLE; or
\code{'selection'} object, as the output from smle_select.}

\item{...}{Other parameters.}

\item{type}{e type of prediction required.
The default is on the scale of the linear predictors; the alternative
"response" is on the scale of the response variable. Thus for a default
binomial model the default predictions are of log-odds (probabilities on
logit scale) and type = "response" gives the predicted probabilities.
The "terms" option returns a matrix giving the fitted values of each
term in the model formula on the linear predictor scale.}

\item{terms}{with type = "terms" by default all terms are returned.
A character vector specifies which terms are to be returned}
}
\value{
The predictor variable
}
\description{
This function returns predictions based on the feature retained from
screening or selected by selection.
}
\details{
First, smle_predict refits the regression model by glm.fit between response
variable and features selected. Then, prediction by predict.glm function.
}
\examples{
set.seed(123.456)

Data_sim<-Gen_Data(n= 200, p =1000, correlation="AR",family = "gaussian")

fit<-SMLE(Data_sim$Y,Data_sim$X, family = "gaussian")

E<-smle_select(fit)

p<-smle_predict(E,type = "link")

}
