% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.smle}
\alias{predict.smle}
\alias{predict.selection}
\title{Prediction based on SMLE screening and selection}
\usage{
\method{predict}{smle}(object, newdata = NULL, ...)

\method{predict}{selection}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{A fitted object of class \code{'smle'} as the output from
SMLE.}

\item{newdata}{Matrix of new values for x at which predictions are to be made,
without the intercept term. If omitted, the function returns the fitted 
response values based on the training data and the retained features in \code{'smle'}.}

\item{...}{Further arguments pass to \code{predict.glm()}.}
}
\value{
The object returned depends on type.
}
\description{
This function makes prediction for the response in new data based on the 
features retained in \code{'smle'} object.
}
\examples{

set.seed(123.456)

Data_sim<-Gen_Data(n= 200, p =1000, correlation="AR",family = "gaussian", num_ctgidx =5)

fit<-SMLE(Data_sim$Y,Data_sim$X, family = "gaussian" , k=10)

predict(fit,newdata= Data_sim$X[10:20,])



}
