% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_wrapper.R
\name{Compute_Power_multi}
\alias{Compute_Power_multi}
\title{Compute the Power of an association study at a given sample size, accommodating more than one covariates, using the Semi-Simulation method.}
\usage{
Compute_Power_multi(
  parameters,
  n,
  response = "binary",
  covariate,
  mode = "additive",
  alpha = 0.05,
  seed = 123,
  searchSizeBeta0 = 8,
  searchSizeGamma0 = 8,
  LargePowerApproxi = FALSE,
  B = 10000
)
}
\arguments{
\item{parameters}{A list of parameters that contains all the required parameters in the model. If response is "binary", this list needs to contain "prev" which denotes the prevalence of the disease (or case to control ratio for case-control sampling). If response is continuous, the list needs to contain "traitSD" and "traitMean" which represent the standard deviation and mean of the continuous trait.
If covariate is not "none", a parameter "gammaG" needs to be defined to capture the dependence between the SNP and the covariate (through linear regression model if covariate is continuous, and logistic model if covariate is binary). If covariate is "binary", list needs to contains "pE" that defines the frequency of the covariate. If it is continuous, list needs to contain "muE" and "sigmaE" to define
its mean and standard deviation. The MAF is defined as "pG", with HWE assumed to hold.}

\item{n}{An integer number that indicates the sample size.}

\item{response}{A string of either "binary" or "continuous", indicating the type of response/trait variable in the model, by default is "binary"}

\item{covariate}{A vector of length two with elements being either c("binary", "continuous"),c("binary", "binary") or c("continuous", "continuous"),  indicating the type of covariate E in the model.}

\item{mode}{A string of either "additive", "dominant" or "recessive", indicating the genetic mode, by default is "additive".}

\item{alpha}{A numeric value that denotes the significance level used in the study, by default is 0.05.}

\item{seed}{An integer number that indicates the seed used for the simulation to compute the approximate fisher information matrix, by default is 123.}

\item{searchSizeBeta0}{The interval radius for the numerical search of beta0, by default is 8. Setting to higher values may solve some numerical problems at the cost of longer runtime.}

\item{searchSizeGamma0}{The interval radius for the numerical search of gamma0, by default is 8. Setting to higher values may solve some numerical problems at the cost of longer runtime.}

\item{LargePowerApproxi}{TRUE or FALSE indicates whether to use the large power approximation formula.}

\item{B}{An integer number that indicates the number of simulated sample to approximate the fisher information matrix, by default is 10000 (Should only be changed if computation uses semi-simulation method).}
}
\value{
The power that can be achieved at the given sample size.
}
\description{
Compute the Power of an association study at a given sample size, accommodating more than one covariates, using the Semi-Simulation method.
}
\examples{
parameters <- list(TraitMean = 0.3, TraitSD = 1, pG = 0.2, betaG = log(1.1),
betaE = c(log(1.1), log(1.2)),
muE = 0, sigmaE = 3, gammaG = c(log(2.1), log(2.2)), pE = 0.4)
SPCompute::Compute_Power_multi(parameters, n = 1000, response = "continuous",
covariate = c("binary", "continuous"))
}
