% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotCreateDesignLhd.R
\name{spotCreateDesignLhd}
\alias{spotCreateDesignLhd}
\title{spotCreateDesignLhd}
\usage{
spotCreateDesignLhd(spotConfig, noDesPoints = NaN, retries = 1)
}
\arguments{
\item{spotConfig}{list of spotConfiguration}

\item{noDesPoints}{number of design points, default is NaN}

\item{retries}{number of retries, which is the number of trials to find a design with the lowest distance, default is 1}
}
\value{
matrix \code{design} \cr
- \code{design} has \code{dimension} columns and \code{noDesPoints} rows
with entries corresponding to the region of interest.
}
\description{
Create a latin hyper cube design based on the number of dimensions and the number of design points.
Designs are created repeatedly. The randomly created design with the lowest between-points-distance is chosen.
A given set of points can be considered during distance calculation (\code{spotConfig$nested.design}). This set may represent a nested, higher level design, as used for
optimization with Co-Kriging or similar approaches. Will be ignored if \code{spotConfig$nested.design} is NULL.
}
\author{
Christian Lasarczyk, adapted for nested designs by Martin Zaefferer
}
\seealso{
\code{\link{spotCreateDesignBasicDoe}}, \code{\link{spotCreateDesignFrF2}},
\code{\link{spotCreateDesignLhs}}, \code{\link{spotCreateDesignLhsOpt}}
}

