% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelMarkovChain.R
\name{preprocessInputData}
\alias{preprocessInputData}
\title{preprocessInputData}
\usage{
preprocessInputData(trainData, populationData)
}
\arguments{
\item{trainData}{data frame}

\item{populationData}{data frame}
}
\value{
A large list (313 elements, 1.3 MB) containing the following information (3 lists) for each of
the 313 regions:
\describe{
     \item{\code{date}}{Date}
     \item{\code{confirmed}}{num Number of confirmed cases (cumulative)}
     \item{\code{fatalities}}{num Number of fatalities (cumulative)} 
}
}
\description{
Combine information from the \code{regionTrain} and the \code{regionPopulation} 
data sets.
}
\details{
Resulting data set can be used as input for the COVID-19 simulations of the 
\code{\link{tuneRegionModel}} function.
}
\examples{
\dontrun{
x <- preprocessInputData(regionTrain, regionPopulation)
## Plot confirmed cases from the first country (Afghanistan):
p <- plot(x[[1]]$date, x[[1]]$confirmed)
}
}
