% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildLM.R
\name{buildLM}
\alias{buildLM}
\title{Linear Model Interface}
\usage{
buildLM(x, y, control = list())
}
\arguments{
\item{x}{matrix of input parameters. Rows for each point, columns for each parameter.}

\item{y}{one column matrix of observations to be modeled.}

\item{control}{list of control parameters, currently only with 
parameters \code{useStep} and \code{formula}. 
The \code{useStep} boolean specifies whether the \code{step} function is used.
The \code{formula} is passed to the lm function.
Without a formula, a second order model will be built.}
}
\value{
an object of class \code{"spotLinearModel"}, 
with a \code{predict} method and a \code{print} method.
}
\description{
This is a simple wrapper for the lm function, which fits linear models.
The purpose of this function is to provide an interface as required by SPOT, 
to enable modeling and model-based optimization with linear models. 
The linear model is build with main effects. 
Optionally, the model is also
subject to the AIC-based stepwise algorithm, 
using the \code{step} function from the \code{stats} package.
}
\examples{
## Test-function:
braninFunction <- function (x) {	
	(x[2]  - 5.1/(4 * pi^2) * (x[1] ^2) + 5/pi * x[1]  - 6)^2 + 
10 * (1 - 1/(8 * pi)) * cos(x[1] ) + 10
}
## Create design points
set.seed(1)
x <- cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points (for Branin function)
y <- as.matrix(apply(x,1,braninFunction))
## Create model
fit <- buildLM(x,y,control = list(algTheta=optimLHD))
## Print model parameters
print(fit)
## Predict at new location
predict(fit,cbind(1,2))
## True value at location
braninFunction(c(1,2))
}
