% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKrigingForrester.R
\name{krigingLikelihood}
\alias{krigingLikelihood}
\title{Calculate negative log-likelihood}
\usage{
krigingLikelihood(
  x,
  AX,
  Ay,
  optimizeP = FALSE,
  useLambda = TRUE,
  penval = 1e+08
)
}
\arguments{
\item{x}{vector, containing parameters log10(theta), log10(lambda) and p.}

\item{AX}{3 dimensional array, constructed by buildKriging from the sample locations}

\item{Ay}{vector of observations at sample locations}

\item{optimizeP}{boolean, whether to optimize parameter p (exponents) or fix at two.}

\item{useLambda}{boolean, whether to use nugget}

\item{penval}{a penalty value which affects the value returned for invalid correlation matrices / configurations}
}
\value{
list with elements\cr
\code{NegLnLike}  concentrated log-likelihood *-1 for minimising \cr
\code{Psi} correlation matrix\cr
\code{Psinv} inverse of correlation matrix (to save computation time during prediction)\cr
\code{mu} \cr
\code{ssq}
}
\description{
Used to determine theta/lambda values for the Kriging model in \code{\link{buildKriging}}.
Supportive function for Kriging model, not to be used directly.
}
\seealso{
\code{\link{buildKriging}}
}
\keyword{internal}
