% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportSensitivityAnalysis.R
\name{subgroups}
\alias{subgroups}
\title{Return effects for each subgroup}
\usage{
subgroups(x)
}
\arguments{
\item{x}{data}
}
\value{
data frame with group names and effects
}
\description{
subgroups: returns the table the effects per groups.
Code based on the \code{sbgroups} function written by Gilles Pujol for
the function \code{\link[sensitivity]{sb}} in the \code{sensitivity} package.
}
\examples{
\donttest{
require("SPOT")
require("RColorBrewer")
set.seed(2)
# Interesting for larger n:
n <- 2
lower <- c(-0.1, rep(-10,n))
upper <- c(0.1, rep(10,n))

# Model-based optimization
res <- spot(,funSphere,
             lower, upper,
             control=list(funEvals=30,
                          optimizer = optimNLOPTR))

# Use the surrogate model for prediction
predictFunKriging <- function(x){
      predict(object = res$modelFit, x)
      }

# Determine sensitivity
sens <- sequentialBifurcation(predictFunKriging,
                              lower, upper,
                              k=n+1, interaction = TRUE, verbosity = 0)

# Extract group information (variable effects) from sensitivity analysis
ps <- subgroups(sens)
colors <- brewer.pal(12, "Set3")
barplot(ps$effect, names.arg=ps$group, col= colors)
}

}
