% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_refimg.R
\name{refImageBinarySVM}
\alias{refImageBinarySVM}
\title{Calculate the binary reference image using linear SVM trained on manually 
selected pixels.}
\usage{
refImageBinarySVM(
  dataset,
  mzQueryRef = numeric(),
  mzTolerance = Inf,
  useFullMZ = TRUE
)
}
\arguments{
\item{dataset}{\link{msi.dataset-class} object. See \link{msiDataset}.}

\item{mzQueryRef}{numeric. Values of m/z used to calculate the reference image.
2 values are interpreted as interval, multiple or single values are searched
in the m/z vector. It overrides the argument \code{useFullMZ}.}

\item{mzTolerance}{numeric (default = Inf). Tolerance in PPM to match the
\code{mzQueryRef} values in the m/z vector.}

\item{useFullMZ}{logical (default = TRUE). Whether all the peaks should be
used to calculate the reference image.}
}
\value{
\link{ms.image-class} object with binary intensities.
}
\description{
Calculate the binary reference image using linear SVM trained on manually 
selected pixels.
}
