% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSVS.R
\name{ssvs}
\alias{ssvs}
\title{Perform SSVS for continuous and binary outcomes}
\usage{
ssvs(
  data,
  y,
  x,
  continuous = TRUE,
  inprob = 0.5,
  runs = 20000,
  burn = 5000,
  a1 = 0.01,
  b1 = 0.01,
  prec.beta = 0.1,
  progress = TRUE
)
}
\arguments{
\item{data}{The dataframe used to extract predictors and response values}

\item{y}{The response variable}

\item{x}{The set of predictor variables}

\item{continuous}{If \code{TRUE}, treat the response variable as continuous. If
\code{FALSE}, treat the response variable as binary.}

\item{inprob}{Prior inclusion probability value, which applies to all predictors.
The prior inclusion probability reflects the prior belief that each predictor
should be included in the model. A prior inclusion probability of .5 reflects
the belief that each predictor has an equal probability of being included or
excluded. Note that a value of .5 also implies a prior belief that the true model
contains half of the candidate predictors. The prior inclusion probability will
influence the magnitude of the marginal inclusion probabilities (MIPs), but the
relative pattern of MIPs is expected to remain fairly consistent, see Bainter et al.
(2020) for more information.}

\item{runs}{Total number of iterations (including burn-in). Results are based on
the Total - Burn-in iterations.}

\item{burn}{Number of burn-in iterations. Burn-in iterations are discarded
warmup iterations used to achieve MCMC convergence. You may increase the number
of burn-in iterations if you are having convergence issues.}

\item{a1}{Prior parameter for Gamma(a,b) distribution on the precision (1/variance)
residual variance. Only used when \code{continuous = TRUE}.}

\item{b1}{Prior parameter for Gamma(a,b) distribution on the precision (1/variance)
residual variance. Only used when \code{continuous = TRUE}.}

\item{prec.beta}{Prior precision (1/variance) for beta coefficients.
Only used when \code{continuous = TRUE}.}

\item{progress}{If \code{TRUE}, show progress of the model creation. When \code{continuous = TRUE},
progress plots will be created for every 1000 iterations. When \code{continuous = FALSE},
10 progress messages will be printed.
Only used when \code{continuous = TRUE}.}
}
\value{
An SSVS object that can be used in
\code{\link[=summary.ssvs]{summary()}} or \code{\link[=plot.ssvs]{plot()}}.
}
\description{
For continuous outcomes, a basic Gibbs sampler is used. For binary
outcomes, \code{\link[BoomSpikeSlab:logit.spike]{BoomSpikeSlab::logit.spike()}} is used.
}
\examples{
\donttest{
# Example 1: continuous response variable
outcome <- "qsec"
predictors <- c("cyl", "disp", "hp", "drat", "wt", "vs", "am", "gear", "carb", "mpg")
results <- ssvs(data = mtcars, x = predictors, y = outcome, progress = FALSE)

# Example 2: binary response variable
library(AER)
data(Affairs)
Affairs$hadaffair[Affairs$affairs > 0] <- 1
Affairs$hadaffair[Affairs$affairs == 0] <- 0
outcome <- "hadaffair"
predictors <- c("gender", "age", "yearsmarried", "children", "religiousness",
"education", "occupation", "rating")
results <- ssvs(data = Affairs, x = predictors, y = outcome, continuous = FALSE, progress = FALSE)
}
}
