\name{plot.frt}
\alias{plot.frt}
\alias{summary.frt}
\title{Plots and Summarizes frt Objects.}
\description{
  \code{plot.frt} generates interactively (by default) 2 plots, the
  survivor function with confidence intervals and the Berman's test with
  confidence bands. \code{summary.frt} generates a concise summary of
  \code{frt} objects. It is mostly
  intended for use in batch processing situations where a decision to stop with the
  current model or go on with a more complicated one must be made automatically. 
}
\usage{
\method{plot}{frt}(x, which = 1:2, main,
         caption = c("Log Survivor Function", "Berman's Test"),
         ask = TRUE, ...)
\method{summary}{frt}(object, ...)
}

\arguments{
  \item{x}{a \code{transformedTrain} object.}
  \item{object}{a \code{transformedTrain} object.}
  \item{which}{if a subset of the plots is required, specify a subset of
    the numbers \code{1:2}.}
  \item{main}{title to appear above the plots, if missing the
    corresponding element of \code{caption} will be used.}
  \item{caption}{Default caption to appear above the plots or, if
    \code{main} is given, bellow it}
  \item{ask}{logical; if \code{TRUE}, the user is \emph{ask}ed before
    each plot, see \code{\link{par}(ask=.)}.}
  \item{\dots}{additional arguments passed to \code{\link{plot}}.}
}
\details{
  If the reference and test (transformed) spike trains used in the
  \code{\link{frt}} call which generated \code{x} (or \code{object}) are
  not correlated (and if the transformed test train is indeed
  homogeneous Poisson with rate 1), the elements of \code{x} (or
  \code{object}) should be iid realizations of an exponential with rate
  1. Two test plots are generated by \code{plot.frt} in the same way as
  the corresponding ones (testing the same thing) of
  \code{\link{plot.transformedTrain}}.

  The same correspondence holds between \code{summary.frt} and
  \code{\link{summary.transformedTrain}}. 
}
\value{
  \code{summary.frt} returns a vector with named elements stating if the
  Berman's test is passed with a 95\% and a 99\% confidence.
}
\author{Christophe Pouzat  \email{christophe.pouzat@gmail.com}}
\seealso{
  \code{\link{transformedTrain}},
  \code{\link{frt}},
  \code{\link{mkGLMdf}}
}
\examples{
\dontrun{
## Let us consider neuron 1 of the CAL2S data set
data(CAL2S)
CAL2S <- lapply(CAL2S,as.spikeTrain)
CAL2S[["neuron 1"]]
renewalTestPlot(CAL2S[["neuron 1"]])
summary(CAL2S[["neuron 1"]])
## Make a data frame with a 4 ms time resolution
cal2Sdf <- mkGLMdf(CAL2S,0.004,0,60)
## keep the part relative to neuron 1, 2 and 3 separately
n1.cal2sDF <- cal2Sdf[cal2Sdf$neuron=="1",]
n2.cal2sDF <- cal2Sdf[cal2Sdf$neuron=="2",]
n3.cal2sDF <- cal2Sdf[cal2Sdf$neuron=="3",]
## remove unnecessary data
rm(cal2Sdf)
## Extract the elapsed time since the second to last and
## third to last for neuron 1. Normalise the result. 
n1.cal2sDF[c("rlN.1","rsN.1","rtN.1")] <- brt4df(n1.cal2sDF,"lN.1",2,c("rlN.1","rsN.1","rtN.1"))
## load mgcv library
library(mgcv)
## fit a model with a tensorial product involving the last
## three spikes and using a cubic spline basis for the last two
## To gain time use a fixed df regression spline
n1S.fitA <- gam(event ~ te(rlN.1,rsN.1,bs="cr",fx=TRUE) + rtN.1,data=n1.cal2sDF,family=binomial(link="logit"))
## transform time
N1.Lambda <- transformedTrain(n1S.fitA)
## check out the resulting spike train using the fact
## that transformedTrain objects inherit from spikeTrain
## objects
N1.Lambda
## Use more formal checks
summary(N1.Lambda)
plot(N1.Lambda,which=c(1,2,4,5),ask=FALSE)
## Transform spike trains of neuron 2 and 3
N2.Lambda <- transformedTrain(n1S.fitA,n2.cal2sDF$event)
N3.Lambda <- transformedTrain(n1S.fitA,n3.cal2sDF$event)
## Check interactions
summary(N2.Lambda \%frt\% N1.Lambda)
summary(N3.Lambda \%frt\% N1.Lambda)
plot(N2.Lambda \%frt\% N1.Lambda,ask=FALSE)
plot(N3.Lambda \%frt\% N1.Lambda,ask=FALSE)
}
}
\keyword{models}
