% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/splineMPST.R
\name{splineMPST}
\alias{splineMPST}
\title{Median polish Spline.}
\usage{
splineMPST(Grid,Ef_t,MPST,eps, maxiter)
}
\arguments{
\item{Grid}{grid with the coordinates in space "x", "y", "z", where will be viewed trend.}

\item{Ef_t}{it's the temporal scenary to look trend.}

\item{MPST}{object of class \code{\link{ConstructMPst}}.}

\item{eps}{real number greater than \code{0}, default 0.01. A tolerance for convergence.}

\item{maxiter}{the maximum number of iterations, default 10.}
}
\value{
Data frame, where columns show the trend in each spatio - temporal location.
}
\description{
The "splineMPST" is dessigned to represent the variability of effects of spatio - temporal data on a surface, from robust median polish algoritm and planar interpolation.
}
\examples{
## Not run:
data(Metadb)
x<-matrix(0,1,37)
for(i in 1:37){
 x[,i] <- 2007 + (seq(0, 36)/12)[i]
}
x<-as.Date (as.yearmon(x), frac = 1)
time = as.POSIXct(x, tz = "GMT")
length(time)

MPST<-ConstructMPst(Metadb[,-c(1:4)],time,pts=Metadb[,2:4],Delta=c(7,6,5))

MpSTData<-MedianPolishM(MPST,eps=0, maxiter=5, na.rm=TRUE)

data(DemMeta)
xy = SpatialPoints(Metadb[,2:4],CRS(proj4string(DemMeta)))

data(HZRMeta)
proj4string(HZRMeta)<-CRS(proj4string(DemMeta))

polygon1 = polygons(HZRMeta)
Gridxy<- spsample(polygon1, cellsize=2000, n=300,"regular")

Grid<-data.frame(Gridxy,over(Gridxy,DemMeta))
colnames(Grid)<-c("East", "North","height")

TendenciaGrilla<-splineMPST(Grid,Ef_t=time[10:15],MPST,eps=0.01, maxiter=2)

IDs = paste("ID",1:length(TendenciaGrilla[,5]))
mydata = data.frame(values = TendenciaGrilla[,5], ID=IDs)
wind.ST1 = STFDF(SpatialPixels(Gridxy),time[10:15],mydata)
stplot(wind.ST1,col.regions=bpy.colors(40),par.strip.text = list(cex=0.7)
      ,main="Spline median polish: Monthly Precipitation")
## End(Not run)
}
\references{
Berke, O. (2001). \emph{Modified median polish kriging and its application to the wolfcamp - aquifer data.} Environmetrics, 12(8):731-748.\href{http://onlinelibrary.wiley.com/doi/10.1002/env.495/abstract}{[link]}

Cressie, N. (1993). \emph{Statistics for spatial data.} Wiley series in probability and statistics.\href{http://www.wiley.com/WileyCDA/WileyTitle/productCd-1119115183.html}{[link]}
}

