% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunction.R
\name{STSIdentifyTightSTMotifs}
\alias{STSIdentifyTightSTMotifs}
\title{Filter the motifs}
\usage{
STSIdentifyTightSTMotifs(stmotifs, rectangles)
}
\arguments{
\item{stmotifs}{List of motifs which past the previous check}

\item{rectangles}{Information about the position of all blocks into the orginal dataset}
}
\value{
Return a list of motifs [Isaxcode, Recmatrix, Vectst, SOtight, GOtight, SO, GO] which past the fliter, each motif contrains :

Isaxcode : Motif sequences in character format

Recmatrix : Matrix giving as information the blocks containing this motif

Vectst : Coordinate of the start positions of the motif in the original dataset

SOtight : Spatial Occurrences after removing outliers

GOtight : Global Occurrences after removing outliers

SO : Spatial Occurrences before removing outliers

GO : Global Occurrences before removing outliers
}
\description{
Using the cluster to remove isolated motifs for each seleted motifs and after that recheck the global and spatial occurences.
}
\note{
To see how motifs are filtered (see part 2) : \href{../inst/doc/check-candidates.html}{Motifs filtering}
}
\examples{
#Generation of candidates
candidates <- STSIdentifyCandidateSTMotifs(STMotif::example_dataset, 10, 10, 7, 3)

#Filter the selected motifs by their occurences
stmotifs <- STSIdentifySTMotifs(candidates, 1, 1)

#Remove the outliers
sttightmotifs <- STSIdentifyTightSTMotifs(stmotifs, candidates$rectangles)
}
