% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max-reps.R
\name{max_reps}
\alias{max_reps}
\alias{max_reps_epley}
\alias{max_reps_modified_epley}
\alias{max_reps_linear}
\title{Family of functions to estimate max number of repetition (nRM)}
\usage{
max_reps_epley(perc_1RM, k = 0.0333)

max_reps_modified_epley(perc_1RM, kmod = 0.0353)

max_reps_linear(perc_1RM, klin = 33)
}
\arguments{
\item{perc_1RM}{Numeric vector. \% 1RM used (use 0.5 for 50 \%, 0.9 for 90 \%)}

\item{k}{User defined \code{k} parameter in the Epley's equation. Default is 0.0333}

\item{kmod}{User defined \code{kmod} parameter in the Modified Epley's equation. Default is 0.0353}

\item{klin}{User defined \code{klin} parameter in the Linear equation. Default is 33}
}
\value{
Numeric vector. Predicted maximal number of repetitions (nRM)
}
\description{
Family of functions to estimate max number of repetition (nRM)
}
\section{Functions}{
\itemize{
\item \code{max_reps_epley}: Estimate max number of repetition (nRM) using the Epley's equation

\item \code{max_reps_modified_epley}: Estimate max number of repetition (nRM) using the Modified Epley's equation

\item \code{max_reps_linear}: Estimate max number of repetition (nRM) using the Linear/Brzycki's equation
}}

\examples{
# ------------------------------------------
# Epley equation
max_reps_epley(0.85)
max_reps_epley(c(0.75, 0.85), k = 0.04)
# ------------------------------------------
# Modified Epley equation
max_reps_modified_epley(0.85)
max_reps_modified_epley(c(0.75, 0.85), kmod = 0.05)
# ------------------------------------------
# Linear/Brzycki's equation
max_reps_linear(0.85)
max_reps_linear(c(0.75, 0.85), klin = 36)
}
