% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{draw.fully.sampled}
\alias{draw.fully.sampled}
\title{For a sample with no unsampled hosts, draw the annotated phylogeny using \code{ggtree}}
\usage{
draw.fully.sampled(generator, sample)
}
\arguments{
\item{generator}{A list of class \code{tt.generator} produced by \code{tt.generator}.}

\item{sample}{A list of class \code{tt} produced by \code{sample.tt} or \code{sample.partial.tt}}
}
\value{
A \code{ggtree} object
}
\description{
For a sample with no unsampled hosts, draw the annotated phylogeny using \code{ggtree}
}
\examples{
generator <- tt.generator(stratus.example.tree)
samples <- sample.tt(generator, 1)
draw.fully.sampled(generator, samples[[1]])
}
