% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapPoints.R
\name{mapPoints}
\alias{mapPoints}
\title{Map GPS points to polygon regions}
\usage{
mapPoints(data, geo, long, lat, names)
}
\arguments{
\item{data}{point data with two columns of GPS locations.}

\item{geo}{SpatialPolygonsDataFrame of the map}

\item{long}{column name for longitudinal coordinate in the data}

\item{lat}{column name for latitude coordinate in the data}

\item{names}{character vector of region ids to be added to the neighbours list}
}
\value{
Spatial djacency matrix.
}
\description{
Map GPS points to polygon regions
}
\examples{
data(DemoMap) 
dat <- data.frame(ID = c(1,2,3), lon = c(32.2, 33.7, 33), lat = c(0.1, 0.9, 2.8))
dat2 <- mapPoints(dat, DemoMap$geo, long = "lon", lat = "lat", names = "REGNAME")
dat2
 
}
\author{
Zehang Richard Li
}
