/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGTests;

public class SVGSwitchElementBridge
extends AbstractSVGBridge
implements GraphicsNodeBridge {
    public String getLocalName() {
        return "switch";
    }

    public Bridge getInstance() {
        return this;
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        GraphicsNode graphicsNode = null;
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                object = (Element)node;
                if (node instanceof SVGTests && SVGUtilities.matchUserAgent((Element)object, bridgeContext.getUserAgent())) {
                    graphicsNode = gVTBuilder.build(bridgeContext, (Element)object);
                    break;
                }
            }
            node = node.getNextSibling();
        }
        if (graphicsNode == null) {
            return null;
        }
        object = new CompositeGraphicsNode();
        object.add(graphicsNode);
        String string = element.getAttributeNS(null, "transform");
        if (string.length() != 0) {
            object.setTransform(SVGUtilities.convertTransform(element, "transform", string));
        }
        return object;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (bridgeContext.isInteractive()) {
            bridgeContext.bind(element, graphicsNode);
        }
    }

    public boolean getDisplay(Element element) {
        return CSSUtilities.convertDisplay(element);
    }

    public boolean isComposite() {
        return false;
    }
}

