% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/swmpr_organize.R
\name{subset.swmpr}
\alias{subset.swmpr}
\title{Subset a swmpr object}
\usage{
\method{subset}{swmpr}(x, subset = NULL, select = NULL, operator = NULL,
  rem_rows = FALSE, rem_cols = FALSE, ...)
}
\arguments{
\item{x}{input swmpr object}

\item{subset}{chr string of form 'YYYY-mm-dd HH:MM' to subset a date range.  Input can be one (requires \code{operator} or two values (a range).}

\item{select}{chr string of parameters to keep}

\item{operator}{chr string specifiying binary operator (e.g., \code{'>'}, \code{'<='}) if subset is one date value}

\item{rem_rows}{logical indicating if rows with no data are removed, default \code{FALSE}}

\item{rem_cols}{is logical indicating if cols with no data are removed, default \code{FALSE}}

\item{...}{arguments passed to other methods}
}
\value{
Returns a swmpr object as a subset of the input.  The original object will be returned if no arguments are specified.
}
\description{
Subset a swmpr object by a date range, parameters, or non-empty values
}
\details{
This function is used to subset swmpr data by date and/or a selected parameter. The date can be a single value or as two dates to select records within the range. The former case requires a binary operator input as a character string passed to the argument, such as \code{>} or \code{<}. The subset argument for the date(s) must also be a character string of the format YYYY-mm-dd HH:MM for each element (i.e., `%Y-%m%-%d %H:%M' in POSIX standards). Be aware that an error may be returned using this function if the subset argument is in the correct format but the calendar date does not exist, e.g. \code{'2012-11-31 12:00'}.  The function can also be used to remove rows and columns that do not contain data, which may be useful after processing with other functions.
}
\examples{
## get data
data(apaebmet)
dat <- apaebmet

## subset records greater than or equal to a date
subset(dat, subset = '2013-01-01 0:00', operator = '>=')

## subset records within a date range, select two parameters
subset(dat, subset = c('2012-07-01 6:00', '2012-08-01 18:15'),
   select = c('atemp', 'totsorad'))
}
\seealso{
\code{\link[base]{subset}}
}
\concept{
organize
}

