% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_sk_flextable_list.R
\name{create_sk_flextable_list}
\alias{create_sk_flextable_list}
\title{Create a List of Flextable Objects}
\usage{
create_sk_flextable_list(sk_result, stations, param, font_sz_stn = 6,
  font_sz_result = 12, font_sz_head = 6, ht_head = 0.28,
  ht_body = 0.202)
}
\arguments{
\item{sk_result}{a \code{data.frame} of reformatted results from \code{\link{sk_seasonal}}}

\item{stations}{chr, vector of stations to be displayed}

\item{param}{chr, vector of parameters to be displayed}

\item{font_sz_stn}{int, specify the font size of displayed station names}

\item{font_sz_result}{int, specify the font size of the displayed results}

\item{font_sz_head}{int, specify the font size of the table header row}

\item{ht_head}{num, specify the cell height of the table body rows. Units for this parameter are in inches.}

\item{ht_body}{num, specify the cell height of the table header row. Units for this parameter are in inches.}
}
\value{
Returns a list of \code{\link[flextable]{flextable}} objects
}
\description{
Create a list of flextable objects to display Seasonal Kendall results in the NERRS reserve level template
}
\details{
This function is intended for internal use with the NERRS reserve level reporting scripts. Using the results from the reserve level trend analysis, \code{create_sk_flextable_list} creates a list of two \code{flextable} objects to be displayed in the NERRS reserve level template. The first \code{flextable} in the list contains the two-letter station IDs for each station and the full location name of each station. The second table lists the seasonal kendall results and the names of the parameters of interest.
}
\author{
Julie Padilla
}
\concept{
reporting
}
