#' US County Map
#'
#' US County boundaries from the US Census Bureau's MAF/TIGER geographic database. Reprojected using Lambert Azimuthal Equal Area.
#'
#' @format A \code{\link[sp]{SpatialPolygonsDataFrame}} object
#'
#' @references United States Census Bureau. Data accessed from the US Census Bureau website: http://www2.census.gov/geo/tiger/GENZ2010/gz_2010_us_050_00_20m.zip; accessed 06 April 2018
#'
#' @docType data
#' @keywords datasets
#' @name us_laea
#' @usage data(us_laea)
#' @source \href{https://www.census.gov/geographies/mapping-files.html}{US Census Bureau}
#'

"us_laea"
