% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILOWriteFunctionsforSource.R
\name{SILOWriteFunctionsforSource}
\alias{SILOWriteFunctionsforSource}
\title{Function to bulk create functions for SILO data in Source.}
\usage{
SILOWriteFunctionsforSource(
  X,
  boundary,
  shpColumn,
  functionsfile,
  RRfile,
  RainfallDatasourcesFolder,
  PETDatasourcesFolder,
  RainfallDatafile,
  PETDatafile,
  fus
)
}
\arguments{
\item{X}{List of SILO station data, loaded into R using SILOLoad.}

\item{boundary}{path to a subcatchment shapefile containing the subcatchments in the Source catchment model}

\item{shpColumn}{column in the shapefile attribute table that corresponds to the catchment numbering.}

\item{functionsfile}{filename to create with functions to import into Source}

\item{RRfile}{filename to create to be imported into the Source Rainfall Runoff feature table}

\item{RainfallDatasourcesFolder}{Name to use when creating a folder in the Source function editor for the rainfall functions and time series variables}

\item{PETDatasourcesFolder}{Name to use when creating a folder in the Source function editor for the PET functions and time series variables}

\item{RainfallDatafile}{Filename of data source loaded in Source for rainfall, in formatting used by Source (e.g. for a file called Rain.csv from a relative folder called TimeseriesData is TimeSeriesData_Rain_csv).}

\item{PETDatafile}{Filename of data source loaded in Source for PET, in formatting used by Source}

\item{fus}{character vector of function unit names in the model.

It is assumed that the Source rainfall-runoff scenario was created using the Geographic wizard, using the 'draw network' method (as opposed to DEM based)
This allows a raster to be loaded into Source, with an integer in each cell representing the different subcatchments. 
\code{boundary} should be the path to a polygon shapefile with these catchment boundaries, and an attribute column that represent the catchment numbers. 
Typically this shapefile will be used to generate the raster that Source requires.

This function will create two files:
\itemize{
\item \code{functionsfile} one to be imported into Source using the Function Import/Export plugin. 
The functions in the file that will be imported are a time series function for each SILO site in \code{X} and a function
weighting these SILO sites using Thiessen polygon areas for each subcatchment in \code{boundary}
\item \code{RRFile} This file points each subcatchment and functional unit to the relevant function created for 
rainfall and PET, to be Imported in the Rainfall Runoff feature table (Edit-Rainfall Runoff Models and Import button)
}}
}
\value{
Nothing to the R environment. Files \code{functionsfile} and \code{RRfile} are created.
}
\description{
Function to bulk create functions for SILO data in Source.
}
\examples{
\dontrun{
X<-SILOLoad(sites)
shpColumn<-"OBJECTID"
functionsfile<-"functions.csv"
RRfile<-"RRFile.csv"
RainfallDatasourcesFolder<-"Rainfall"
PETDatasourcesFolder<-"PET"
RainfallDatafile<-"TimeSeriesData_Rain_csv"
PETDatafile<-"TimeSeriesData_MWet_csv"
fus<-c("regolith","igneous","carbonate","sedimentary")
SILOWriteFunctionsforSource(X,boundary,shpColumn,functionsfile,RRfile,
                            RainfallDatasourcesFolder,PETDatasourcesFolder,
                          RainfallDatafile,PETDatafile,fus)
}
}
