% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/psum.R
\encoding{UTF-8}
\name{psum}
\alias{psum}
\title{Parallel sum}
\usage{
psum(..., na.rm = FALSE)
}
\arguments{
\item{na.rm}{A logical value \code{TRUE} or \code{FALSE}, the default}

\item{\dots}{One or more unit objects}
}
\value{
A vector containing the parallel sum.
}
\description{
Provides parallel sum like \code{pmin} and \code{pmax} from the base package. The function \code{sum} simply does not help when the objective is to obtain a vector with parallel sum rather than a scalar value.
}
\examples{
n <- 20
mydat <- data.frame(PT = rnorm(n, mean = .30),
PSDB = rnorm(n, mean = .25), PSB = rnorm(n, mean = .15))
transform(mydat, DK = psum(PT, PSDB, PSB - 1))
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Misc}

