% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/seatAllocation.R
\encoding{UTF-8}
\name{dHondt}
\alias{dHondt}
\title{The D'Hondt Method of Allocating Seats Proportionally}
\usage{
dHondt(parties = NULL, votes = NULL, seats = NULL, ...)

dHondt(parties = NULL, votes = NULL, seats = NULL, ...)
}
\arguments{
\item{parties}{A vector containig parties labels or candidates accordingly to the \code{votes} vector order.}

\item{votes}{A vector containing the total number of formal votes received by the parties/candidates.}

\item{seats}{An integer for the number of seats to be filled (the district magnitude).}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A \code{data.frame} of length \code{parties} containing apportioned integers (seats) summing to \code{seats}.
}
\description{
The function calculate the seats allotment in legislative house, given the total number of seats and the votes for each party based on the Victor D'Hondt's method (1878), which is mathematically equivalent to the method proposed by Thomas Jefferson few years before (1792).
}
\note{
Adapted from Carlos Bellosta's replies in the R-list.
}
\examples{
# Example: 2014 Brazilian election for the lower house in
# the state of Ceara. Coalitions were leading by the
# following parties:

results <- c(DEM=490205, PMDB=1151547, PRB=2449440,
PSB=48274, PSTU=54403, PTC=173151)

dHondt(parties=names(results), votes=results, seats=19)

# The next example is for the state legislative house of Ceara (2014):

votes <- c(187906, 326841, 132531, 981096, 2043217,15061,103679,109830, 213988, 67145, 278267)

parties <- c("PCdoB", "PDT","PEN", "PMDB", "PRB","PSB","PSC", "PSTU", "PTdoB", "PTC", "PTN")

dHondt(parties, votes , seats=42)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\references{
Lijphart, Arend (1994). \emph{Electoral Systems and Party Systems: A Study of Twenty-Seven Democracies, 1945-1990}. Oxford University Press.
}
\seealso{
\code{\link{highestAverages}}, \code{\link{largestRemainders}},  \code{\link{hamilton}}, \code{\link{politicalDiversity}}.
}
\keyword{Electoral}

