% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/seatAllocation.R
\encoding{latin1}
\name{largestRemainders}
\alias{largestRemainders}
\alias{largestRemainders.default}
\title{Largest Remainders Methods of Allocating Seats Proportionally}
\usage{
largestRemainders(parties = NULL, votes = NULL, seats = NULL,
  method = c("dh", "sl", "msl", "danish", "hsl", "hh", "imperiali", "wb",
  "jef", "ad", "hb"), threshold = 0, ...)

\method{largestRemainders}{default}(parties = NULL, votes = NULL,
  seats = NULL, method = c("dh", "sl", "msl", "danish", "hsl", "hh",
  "imperiali", "wb", "jef", "ad", "hb"), threshold = 0, ...)
}
\arguments{
\item{parties}{A character vector for parties labels or candidates in the order as \code{votes}. If \code{NULL}, a random combination of letters will be assigned.}

\item{votes}{A numeric vector for the number of formal votes received by each party or candidate.}

\item{seats}{The number of seats to be filled (scalar or vector).}

\item{method}{A character name for the method to be used. See details.}

\item{threshold}{A numeric value between (0~1). Default is set to 0.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A \code{data.frame} of length \code{parties} containing apportioned integers (seats) summing to \code{seats}.
}
\description{
Computes the largest remainders method for a variety of formulas of allocating seats proportionally.
}
\details{
The following methods are available:
\itemize{
\item {"dh"}{d'Hondt method}
\item {"sl"}{Sainte-Lague method}
}
}
\examples{
# Let's create a data.frame with typical election results
# with the following parties and votes to return 10 seats:

my_election <- data.frame(
party=c("Yellow", "White", "Red", "Green", "Blue", "Pink"),
votes=c(47000, 16000,	15900,	12000,	6000,	3100))

largestRemainders(my_election$party,
my_election$votes, seats = 10,  method="droop")
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\references{
Gallagher, Michael (1992). "Comparing Proportional Representation
Electoral Systems: Quotas, Thresholds, Paradoxes and Majorities".
\emph{British Journal of Political Science}, 22, 4, 469-496.

 Lijphart, Arend (1994). \emph{Electoral Systems and Party Systems: A Study of Twenty-Seven Democracies, 1945-1990}. Oxford University Press.
}
\seealso{
\code{\link{highestAverages}}, \code{\link{dHondt}}, \code{\link{hamilton}}, \code{\link{politicalDiversity}}. For more details see the \emph{Indices} vignette: \code{vignette('Indices', package = 'SciencesPo')}.
}
\keyword{Electoral}

